/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableSecretBuildSource;
import io.fabric8.openshift.api.model.SecretBuildSource;
import io.fabric8.openshift.api.model.SecretBuildSourceFluent;
import io.fabric8.openshift.api.model.SecretBuildSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SecretBuildSourceBuilder
extends SecretBuildSourceFluentImpl<SecretBuildSourceBuilder>
implements VisitableBuilder<SecretBuildSource, SecretBuildSourceBuilder> {
    SecretBuildSourceFluent<?> fluent;

    public SecretBuildSourceBuilder() {
        this(new SecretBuildSource());
    }

    public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent) {
        this(fluent, new SecretBuildSource());
    }

    public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent, SecretBuildSource instance) {
        this.fluent = fluent;
        fluent.withDestinationDir(instance.getDestinationDir());
        fluent.withSecret(instance.getSecret());
    }

    public SecretBuildSourceBuilder(SecretBuildSource instance) {
        this.fluent = this;
        this.withDestinationDir(instance.getDestinationDir());
        this.withSecret(instance.getSecret());
    }

    @Override
    public EditableSecretBuildSource build() {
        EditableSecretBuildSource buildable = new EditableSecretBuildSource(this.fluent.getDestinationDir(), this.fluent.getSecret());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretBuildSourceBuilder that = (SecretBuildSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

