/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableStatusDetails;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.api.model.StatusDetailsFluent;
import io.fabric8.kubernetes.api.model.StatusDetailsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class StatusDetailsBuilder
extends StatusDetailsFluentImpl<StatusDetailsBuilder>
implements VisitableBuilder<StatusDetails, StatusDetailsBuilder> {
    StatusDetailsFluent<?> fluent;

    public StatusDetailsBuilder() {
        this(new StatusDetails());
    }

    public StatusDetailsBuilder(StatusDetailsFluent<?> fluent) {
        this(fluent, new StatusDetails());
    }

    public StatusDetailsBuilder(StatusDetailsFluent<?> fluent, StatusDetails instance) {
        this.fluent = fluent;
        fluent.withCauses(instance.getCauses());
        fluent.withGroup(instance.getGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withRetryAfterSeconds(instance.getRetryAfterSeconds());
    }

    public StatusDetailsBuilder(StatusDetails instance) {
        this.fluent = this;
        this.withCauses(instance.getCauses());
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withRetryAfterSeconds(instance.getRetryAfterSeconds());
    }

    @Override
    public EditableStatusDetails build() {
        EditableStatusDetails buildable = new EditableStatusDetails(this.fluent.getCauses(), this.fluent.getGroup(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getRetryAfterSeconds());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatusDetailsBuilder that = (StatusDetailsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

