/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicyBinding;
import io.fabric8.openshift.api.model.ClusterPolicyBindingFluent;
import io.fabric8.openshift.api.model.NamedClusterRoleBinding;
import io.fabric8.openshift.api.model.NamedClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.NamedClusterRoleBindingFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterPolicyBindingFluentImpl<T extends ClusterPolicyBindingFluent<T>>
extends BaseFluent<T>
implements ClusterPolicyBindingFluent<T> {
    ClusterPolicyBinding.ApiVersion apiVersion;
    String kind;
    String lastModified;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<ObjectReference, ?> policyRef;
    List<VisitableBuilder<NamedClusterRoleBinding, ?>> roleBindings = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ClusterPolicyBindingFluentImpl() {
    }

    public ClusterPolicyBindingFluentImpl(ClusterPolicyBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLastModified(instance.getLastModified());
        this.withMetadata(instance.getMetadata());
        this.withPolicyRef(instance.getPolicyRef());
        this.withRoleBindings(instance.getRoleBindings());
    }

    @Override
    public ClusterPolicyBinding.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(ClusterPolicyBinding.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public String getLastModified() {
        return this.lastModified;
    }

    @Override
    public T withLastModified(String lastModified) {
        this.lastModified = lastModified;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public ClusterPolicyBindingFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterPolicyBindingFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterPolicyBindingFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ObjectReference getPolicyRef() {
        return this.policyRef != null ? (ObjectReference)this.policyRef.build() : null;
    }

    @Override
    public T withPolicyRef(ObjectReference policyRef) {
        if (policyRef != null) {
            this.policyRef = new ObjectReferenceBuilder(policyRef);
            this._visitables.add(this.policyRef);
        }
        return (T)this;
    }

    @Override
    public ClusterPolicyBindingFluent.PolicyRefNested<T> withNewPolicyRef() {
        return new PolicyRefNestedImpl();
    }

    @Override
    public ClusterPolicyBindingFluent.PolicyRefNested<T> withNewPolicyRefLike(ObjectReference item) {
        return new PolicyRefNestedImpl(item);
    }

    @Override
    public ClusterPolicyBindingFluent.PolicyRefNested<T> editPolicyRef() {
        return this.withNewPolicyRefLike(this.getPolicyRef());
    }

    @Override
    public T addToRoleBindings(NamedClusterRoleBinding ... items) {
        for (NamedClusterRoleBinding item : items) {
            NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);
            this._visitables.add(builder);
            this.roleBindings.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromRoleBindings(NamedClusterRoleBinding ... items) {
        for (NamedClusterRoleBinding item : items) {
            NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);
            this._visitables.remove(builder);
            this.roleBindings.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<NamedClusterRoleBinding> getRoleBindings() {
        return this.build(this.roleBindings);
    }

    @Override
    public T withRoleBindings(List<NamedClusterRoleBinding> roleBindings) {
        this.roleBindings.clear();
        if (roleBindings != null) {
            for (NamedClusterRoleBinding item : roleBindings) {
                this.addToRoleBindings(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withRoleBindings(NamedClusterRoleBinding ... roleBindings) {
        this.roleBindings.clear();
        if (roleBindings != null) {
            for (NamedClusterRoleBinding item : roleBindings) {
                this.addToRoleBindings(item);
            }
        }
        return (T)this;
    }

    @Override
    public ClusterPolicyBindingFluent.RoleBindingsNested<T> addNewRoleBinding() {
        return new RoleBindingsNestedImpl();
    }

    @Override
    public ClusterPolicyBindingFluent.RoleBindingsNested<T> addNewRoleBindingLike(NamedClusterRoleBinding item) {
        return new RoleBindingsNestedImpl(item);
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterPolicyBindingFluentImpl that = (ClusterPolicyBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.policyRef != null ? !this.policyRef.equals(that.policyRef) : that.policyRef != null) {
            return false;
        }
        if (this.roleBindings != null ? !this.roleBindings.equals(that.roleBindings) : that.roleBindings != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class RoleBindingsNestedImpl<N>
    extends NamedClusterRoleBindingFluentImpl<ClusterPolicyBindingFluent.RoleBindingsNested<N>>
    implements ClusterPolicyBindingFluent.RoleBindingsNested<N> {
        private final NamedClusterRoleBindingBuilder builder;

        RoleBindingsNestedImpl() {
            this.builder = new NamedClusterRoleBindingBuilder(this);
        }

        RoleBindingsNestedImpl(NamedClusterRoleBinding item) {
            this.builder = new NamedClusterRoleBindingBuilder(this, item);
        }

        @Override
        public N endRoleBinding() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ClusterPolicyBindingFluentImpl.this.addToRoleBindings(this.builder.build());
        }
    }

    public class PolicyRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<ClusterPolicyBindingFluent.PolicyRefNested<N>>
    implements ClusterPolicyBindingFluent.PolicyRefNested<N> {
        private final ObjectReferenceBuilder builder;

        PolicyRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        PolicyRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N endPolicyRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ClusterPolicyBindingFluentImpl.this.withPolicyRef(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterPolicyBindingFluent.MetadataNested<N>>
    implements ClusterPolicyBindingFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterPolicyBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

