/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.kubernetes.api.model.extensions.JobFluent;
import io.fabric8.kubernetes.api.model.extensions.JobSpec;
import io.fabric8.kubernetes.api.model.extensions.JobSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.JobStatus;
import io.fabric8.kubernetes.api.model.extensions.JobStatusBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobStatusFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class JobFluentImpl<T extends JobFluent<T>>
extends BaseFluent<T>
implements JobFluent<T> {
    Job.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<JobSpec, ?> spec;
    VisitableBuilder<JobStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public JobFluentImpl() {
    }

    public JobFluentImpl(Job instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public Job.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(Job.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public JobFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public JobFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public JobFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public JobSpec getSpec() {
        return this.spec != null ? (JobSpec)this.spec.build() : null;
    }

    @Override
    public T withSpec(JobSpec spec) {
        if (spec != null) {
            this.spec = new JobSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    @Override
    public JobFluent.SpecNested<T> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public JobFluent.SpecNested<T> withNewSpecLike(JobSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public JobFluent.SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public JobStatus getStatus() {
        return this.status != null ? (JobStatus)this.status.build() : null;
    }

    @Override
    public T withStatus(JobStatus status) {
        if (status != null) {
            this.status = new JobStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    @Override
    public JobFluent.StatusNested<T> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public JobFluent.StatusNested<T> withNewStatusLike(JobStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public JobFluent.StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobFluentImpl that = (JobFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StatusNestedImpl<N>
    extends JobStatusFluentImpl<JobFluent.StatusNested<N>>
    implements JobFluent.StatusNested<N> {
        private final JobStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new JobStatusBuilder(this);
        }

        StatusNestedImpl(JobStatus item) {
            this.builder = new JobStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)JobFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends JobSpecFluentImpl<JobFluent.SpecNested<N>>
    implements JobFluent.SpecNested<N> {
        private final JobSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new JobSpecBuilder(this);
        }

        SpecNestedImpl(JobSpec item) {
            this.builder = new JobSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)JobFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<JobFluent.MetadataNested<N>>
    implements JobFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)JobFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

