/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.EditableHorizontalPodAutoscalerSpec;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpec;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class HorizontalPodAutoscalerSpecBuilder
extends HorizontalPodAutoscalerSpecFluentImpl<HorizontalPodAutoscalerSpecBuilder>
implements VisitableBuilder<HorizontalPodAutoscalerSpec, HorizontalPodAutoscalerSpecBuilder> {
    HorizontalPodAutoscalerSpecFluent<?> fluent;

    public HorizontalPodAutoscalerSpecBuilder() {
        this(new HorizontalPodAutoscalerSpec());
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent) {
        this(fluent, new HorizontalPodAutoscalerSpec());
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent, HorizontalPodAutoscalerSpec instance) {
        this.fluent = fluent;
        fluent.withCpuUtilization(instance.getCpuUtilization());
        fluent.withMaxReplicas(instance.getMaxReplicas());
        fluent.withMinReplicas(instance.getMinReplicas());
        fluent.withScaleRef(instance.getScaleRef());
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpec instance) {
        this.fluent = this;
        this.withCpuUtilization(instance.getCpuUtilization());
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleRef(instance.getScaleRef());
    }

    @Override
    public EditableHorizontalPodAutoscalerSpec build() {
        EditableHorizontalPodAutoscalerSpec buildable = new EditableHorizontalPodAutoscalerSpec(this.fluent.getCpuUtilization(), this.fluent.getMaxReplicas(), this.fluent.getMinReplicas(), this.fluent.getScaleRef());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerSpecBuilder that = (HorizontalPodAutoscalerSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

