/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.FSGroupStrategyOptions;
import io.fabric8.kubernetes.api.model.FSGroupStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.FSGroupStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptions;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptions;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluent;
import io.fabric8.kubernetes.api.model.SupplementalGroupsStrategyOptions;
import io.fabric8.kubernetes.api.model.SupplementalGroupsStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.SupplementalGroupsStrategyOptionsFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecurityContextConstraintsFluentImpl<T extends SecurityContextConstraintsFluent<T>>
extends BaseFluent<T>
implements SecurityContextConstraintsFluent<T> {
    Boolean allowEmptyDirVolumePlugin;
    Boolean allowHostDirVolumePlugin;
    Boolean allowHostIPC;
    Boolean allowHostNetwork;
    Boolean allowHostPID;
    Boolean allowHostPorts;
    Boolean allowPrivilegedContainer;
    List<String> allowedCapabilities = new ArrayList<String>();
    SecurityContextConstraints.ApiVersion apiVersion;
    List<String> defaultAddCapabilities = new ArrayList<String>();
    VisitableBuilder<FSGroupStrategyOptions, ?> fsGroup;
    List<String> groups = new ArrayList<String>();
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    Integer priority;
    List<String> requiredDropCapabilities = new ArrayList<String>();
    VisitableBuilder<RunAsUserStrategyOptions, ?> runAsUser;
    VisitableBuilder<SELinuxContextStrategyOptions, ?> seLinuxContext;
    VisitableBuilder<SupplementalGroupsStrategyOptions, ?> supplementalGroups;
    List<String> users = new ArrayList<String>();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public SecurityContextConstraintsFluentImpl() {
    }

    public SecurityContextConstraintsFluentImpl(SecurityContextConstraints instance) {
        this.withAllowEmptyDirVolumePlugin(instance.getAllowEmptyDirVolumePlugin());
        this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin());
        this.withAllowHostIPC(instance.getAllowHostIPC());
        this.withAllowHostNetwork(instance.getAllowHostNetwork());
        this.withAllowHostPID(instance.getAllowHostPID());
        this.withAllowHostPorts(instance.getAllowHostPorts());
        this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer());
        this.withAllowedCapabilities(instance.getAllowedCapabilities());
        this.withApiVersion(instance.getApiVersion());
        this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        this.withFsGroup(instance.getFsGroup());
        this.withGroups(instance.getGroups());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withPriority(instance.getPriority());
        this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxContext(instance.getSeLinuxContext());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withUsers(instance.getUsers());
    }

    @Override
    public Boolean isAllowEmptyDirVolumePlugin() {
        return this.allowEmptyDirVolumePlugin;
    }

    @Override
    public T withAllowEmptyDirVolumePlugin(Boolean allowEmptyDirVolumePlugin) {
        this.allowEmptyDirVolumePlugin = allowEmptyDirVolumePlugin;
        return (T)this;
    }

    @Override
    public Boolean isAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin;
    }

    @Override
    public T withAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
        return (T)this;
    }

    @Override
    public Boolean isAllowHostIPC() {
        return this.allowHostIPC;
    }

    @Override
    public T withAllowHostIPC(Boolean allowHostIPC) {
        this.allowHostIPC = allowHostIPC;
        return (T)this;
    }

    @Override
    public Boolean isAllowHostNetwork() {
        return this.allowHostNetwork;
    }

    @Override
    public T withAllowHostNetwork(Boolean allowHostNetwork) {
        this.allowHostNetwork = allowHostNetwork;
        return (T)this;
    }

    @Override
    public Boolean isAllowHostPID() {
        return this.allowHostPID;
    }

    @Override
    public T withAllowHostPID(Boolean allowHostPID) {
        this.allowHostPID = allowHostPID;
        return (T)this;
    }

    @Override
    public Boolean isAllowHostPorts() {
        return this.allowHostPorts;
    }

    @Override
    public T withAllowHostPorts(Boolean allowHostPorts) {
        this.allowHostPorts = allowHostPorts;
        return (T)this;
    }

    @Override
    public Boolean isAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer;
    }

    @Override
    public T withAllowPrivilegedContainer(Boolean allowPrivilegedContainer) {
        this.allowPrivilegedContainer = allowPrivilegedContainer;
        return (T)this;
    }

    @Override
    public T addToAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    @Override
    public T withAllowedCapabilities(List<String> allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withAllowedCapabilities(String ... allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (T)this;
    }

    @Override
    public SecurityContextConstraints.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(SecurityContextConstraints.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public T addToDefaultAddCapabilities(String ... items) {
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromDefaultAddCapabilities(String ... items) {
        for (String item : items) {
            this.defaultAddCapabilities.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getDefaultAddCapabilities() {
        return this.defaultAddCapabilities;
    }

    @Override
    public T withDefaultAddCapabilities(List<String> defaultAddCapabilities) {
        this.defaultAddCapabilities.clear();
        if (defaultAddCapabilities != null) {
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withDefaultAddCapabilities(String ... defaultAddCapabilities) {
        this.defaultAddCapabilities.clear();
        if (defaultAddCapabilities != null) {
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        }
        return (T)this;
    }

    @Override
    public FSGroupStrategyOptions getFsGroup() {
        return this.fsGroup != null ? (FSGroupStrategyOptions)this.fsGroup.build() : null;
    }

    @Override
    public T withFsGroup(FSGroupStrategyOptions fsGroup) {
        if (fsGroup != null) {
            this.fsGroup = new FSGroupStrategyOptionsBuilder(fsGroup);
            this._visitables.add(this.fsGroup);
        }
        return (T)this;
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<T> withNewFsGroup() {
        return new FsGroupNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<T> withNewFsGroupLike(FSGroupStrategyOptions item) {
        return new FsGroupNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<T> editFsGroup() {
        return this.withNewFsGroupLike(this.getFsGroup());
    }

    @Override
    public T addToGroups(String ... items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromGroups(String ... items) {
        for (String item : items) {
            this.groups.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public T withGroups(List<String> groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withGroups(String ... groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public T withPriority(Integer priority) {
        this.priority = priority;
        return (T)this;
    }

    @Override
    public T addToRequiredDropCapabilities(String ... items) {
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromRequiredDropCapabilities(String ... items) {
        for (String item : items) {
            this.requiredDropCapabilities.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getRequiredDropCapabilities() {
        return this.requiredDropCapabilities;
    }

    @Override
    public T withRequiredDropCapabilities(List<String> requiredDropCapabilities) {
        this.requiredDropCapabilities.clear();
        if (requiredDropCapabilities != null) {
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withRequiredDropCapabilities(String ... requiredDropCapabilities) {
        this.requiredDropCapabilities.clear();
        if (requiredDropCapabilities != null) {
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        }
        return (T)this;
    }

    @Override
    public RunAsUserStrategyOptions getRunAsUser() {
        return this.runAsUser != null ? (RunAsUserStrategyOptions)this.runAsUser.build() : null;
    }

    @Override
    public T withRunAsUser(RunAsUserStrategyOptions runAsUser) {
        if (runAsUser != null) {
            this.runAsUser = new RunAsUserStrategyOptionsBuilder(runAsUser);
            this._visitables.add(this.runAsUser);
        }
        return (T)this;
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<T> withNewRunAsUser() {
        return new RunAsUserNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<T> withNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return new RunAsUserNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<T> editRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser());
    }

    @Override
    public T withNewRunAsUser(String type, Long uid, Long uidRangeMax, Long uidRangeMin) {
        return this.withRunAsUser(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
    }

    @Override
    public SELinuxContextStrategyOptions getSeLinuxContext() {
        return this.seLinuxContext != null ? (SELinuxContextStrategyOptions)this.seLinuxContext.build() : null;
    }

    @Override
    public T withSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
        if (seLinuxContext != null) {
            this.seLinuxContext = new SELinuxContextStrategyOptionsBuilder(seLinuxContext);
            this._visitables.add(this.seLinuxContext);
        }
        return (T)this;
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<T> withNewSeLinuxContext() {
        return new SeLinuxContextNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<T> withNewSeLinuxContextLike(SELinuxContextStrategyOptions item) {
        return new SeLinuxContextNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<T> editSeLinuxContext() {
        return this.withNewSeLinuxContextLike(this.getSeLinuxContext());
    }

    @Override
    public SupplementalGroupsStrategyOptions getSupplementalGroups() {
        return this.supplementalGroups != null ? (SupplementalGroupsStrategyOptions)this.supplementalGroups.build() : null;
    }

    @Override
    public T withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
        if (supplementalGroups != null) {
            this.supplementalGroups = new SupplementalGroupsStrategyOptionsBuilder(supplementalGroups);
            this._visitables.add(this.supplementalGroups);
        }
        return (T)this;
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<T> withNewSupplementalGroups() {
        return new SupplementalGroupsNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<T> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return new SupplementalGroupsNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<T> editSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups());
    }

    @Override
    public T addToUsers(String ... items) {
        for (String item : items) {
            this.users.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromUsers(String ... items) {
        for (String item : items) {
            this.users.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getUsers() {
        return this.users;
    }

    @Override
    public T withUsers(List<String> users) {
        this.users.clear();
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withUsers(String ... users) {
        this.users.clear();
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityContextConstraintsFluentImpl that = (SecurityContextConstraintsFluentImpl)o;
        if (this.allowEmptyDirVolumePlugin != null ? !this.allowEmptyDirVolumePlugin.equals(that.allowEmptyDirVolumePlugin) : that.allowEmptyDirVolumePlugin != null) {
            return false;
        }
        if (this.allowHostDirVolumePlugin != null ? !this.allowHostDirVolumePlugin.equals(that.allowHostDirVolumePlugin) : that.allowHostDirVolumePlugin != null) {
            return false;
        }
        if (this.allowHostIPC != null ? !this.allowHostIPC.equals(that.allowHostIPC) : that.allowHostIPC != null) {
            return false;
        }
        if (this.allowHostNetwork != null ? !this.allowHostNetwork.equals(that.allowHostNetwork) : that.allowHostNetwork != null) {
            return false;
        }
        if (this.allowHostPID != null ? !this.allowHostPID.equals(that.allowHostPID) : that.allowHostPID != null) {
            return false;
        }
        if (this.allowHostPorts != null ? !this.allowHostPorts.equals(that.allowHostPorts) : that.allowHostPorts != null) {
            return false;
        }
        if (this.allowPrivilegedContainer != null ? !this.allowPrivilegedContainer.equals(that.allowPrivilegedContainer) : that.allowPrivilegedContainer != null) {
            return false;
        }
        if (this.allowedCapabilities != null ? !this.allowedCapabilities.equals(that.allowedCapabilities) : that.allowedCapabilities != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.defaultAddCapabilities != null ? !this.defaultAddCapabilities.equals(that.defaultAddCapabilities) : that.defaultAddCapabilities != null) {
            return false;
        }
        if (this.fsGroup != null ? !this.fsGroup.equals(that.fsGroup) : that.fsGroup != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.requiredDropCapabilities != null ? !this.requiredDropCapabilities.equals(that.requiredDropCapabilities) : that.requiredDropCapabilities != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxContext != null ? !this.seLinuxContext.equals(that.seLinuxContext) : that.seLinuxContext != null) {
            return false;
        }
        if (this.supplementalGroups != null ? !this.supplementalGroups.equals(that.supplementalGroups) : that.supplementalGroups != null) {
            return false;
        }
        if (this.users != null ? !this.users.equals(that.users) : that.users != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SupplementalGroupsNestedImpl<N>
    extends SupplementalGroupsStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.SupplementalGroupsNested<N>>
    implements SecurityContextConstraintsFluent.SupplementalGroupsNested<N> {
        private final SupplementalGroupsStrategyOptionsBuilder builder;

        SupplementalGroupsNestedImpl() {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
        }

        SupplementalGroupsNestedImpl(SupplementalGroupsStrategyOptions item) {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withSupplementalGroups(this.builder.build());
        }

        @Override
        public N endSupplementalGroups() {
            return this.and();
        }
    }

    public class SeLinuxContextNestedImpl<N>
    extends SELinuxContextStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.SeLinuxContextNested<N>>
    implements SecurityContextConstraintsFluent.SeLinuxContextNested<N> {
        private final SELinuxContextStrategyOptionsBuilder builder;

        SeLinuxContextNestedImpl() {
            this.builder = new SELinuxContextStrategyOptionsBuilder(this);
        }

        SeLinuxContextNestedImpl(SELinuxContextStrategyOptions item) {
            this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withSeLinuxContext(this.builder.build());
        }

        @Override
        public N endSeLinuxContext() {
            return this.and();
        }
    }

    public class RunAsUserNestedImpl<N>
    extends RunAsUserStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.RunAsUserNested<N>>
    implements SecurityContextConstraintsFluent.RunAsUserNested<N> {
        private final RunAsUserStrategyOptionsBuilder builder;

        RunAsUserNestedImpl() {
            this.builder = new RunAsUserStrategyOptionsBuilder(this);
        }

        RunAsUserNestedImpl(RunAsUserStrategyOptions item) {
            this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
        }

        @Override
        public N endRunAsUser() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withRunAsUser(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<SecurityContextConstraintsFluent.MetadataNested<N>>
    implements SecurityContextConstraintsFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class FsGroupNestedImpl<N>
    extends FSGroupStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.FsGroupNested<N>>
    implements SecurityContextConstraintsFluent.FsGroupNested<N> {
        private final FSGroupStrategyOptionsBuilder builder;

        FsGroupNestedImpl() {
            this.builder = new FSGroupStrategyOptionsBuilder(this);
        }

        FsGroupNestedImpl(FSGroupStrategyOptions item) {
            this.builder = new FSGroupStrategyOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withFsGroup(this.builder.build());
        }

        @Override
        public N endFsGroup() {
            return this.and();
        }
    }
}

