/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.BinaryBuildSource;
import io.fabric8.openshift.api.model.BinaryBuildSourceBuilder;
import io.fabric8.openshift.api.model.BinaryBuildSourceFluentImpl;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.GitBuildSourceBuilder;
import io.fabric8.openshift.api.model.GitBuildSourceFluentImpl;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.ImageSourceBuilder;
import io.fabric8.openshift.api.model.ImageSourceFluentImpl;
import io.fabric8.openshift.api.model.SecretBuildSource;
import io.fabric8.openshift.api.model.SecretBuildSourceBuilder;
import io.fabric8.openshift.api.model.SecretBuildSourceFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildSourceFluentImpl<T extends BuildSourceFluent<T>>
extends BaseFluent<T>
implements BuildSourceFluent<T> {
    VisitableBuilder<BinaryBuildSource, ?> binary;
    String contextDir;
    String dockerfile;
    VisitableBuilder<GitBuildSource, ?> git;
    List<VisitableBuilder<ImageSource, ?>> images = new ArrayList();
    List<VisitableBuilder<SecretBuildSource, ?>> secrets = new ArrayList();
    VisitableBuilder<LocalObjectReference, ?> sourceSecret;
    String type;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildSourceFluentImpl() {
    }

    public BuildSourceFluentImpl(BuildSource instance) {
        this.withBinary(instance.getBinary());
        this.withContextDir(instance.getContextDir());
        this.withDockerfile(instance.getDockerfile());
        this.withGit(instance.getGit());
        this.withImages(instance.getImages());
        this.withSecrets(instance.getSecrets());
        this.withSourceSecret(instance.getSourceSecret());
        this.withType(instance.getType());
    }

    @Override
    public BinaryBuildSource getBinary() {
        return this.binary != null ? (BinaryBuildSource)this.binary.build() : null;
    }

    @Override
    public T withBinary(BinaryBuildSource binary) {
        if (binary != null) {
            this.binary = new BinaryBuildSourceBuilder(binary);
            this._visitables.add(this.binary);
        }
        return (T)this;
    }

    @Override
    public BuildSourceFluent.BinaryNested<T> withNewBinary() {
        return new BinaryNestedImpl();
    }

    @Override
    public BuildSourceFluent.BinaryNested<T> withNewBinaryLike(BinaryBuildSource item) {
        return new BinaryNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.BinaryNested<T> editBinary() {
        return this.withNewBinaryLike(this.getBinary());
    }

    @Override
    public T withNewBinary(String asFile) {
        return this.withBinary(new BinaryBuildSource(asFile));
    }

    @Override
    public String getContextDir() {
        return this.contextDir;
    }

    @Override
    public T withContextDir(String contextDir) {
        this.contextDir = contextDir;
        return (T)this;
    }

    @Override
    public String getDockerfile() {
        return this.dockerfile;
    }

    @Override
    public T withDockerfile(String dockerfile) {
        this.dockerfile = dockerfile;
        return (T)this;
    }

    @Override
    public GitBuildSource getGit() {
        return this.git != null ? (GitBuildSource)this.git.build() : null;
    }

    @Override
    public T withGit(GitBuildSource git) {
        if (git != null) {
            this.git = new GitBuildSourceBuilder(git);
            this._visitables.add(this.git);
        }
        return (T)this;
    }

    @Override
    public BuildSourceFluent.GitNested<T> withNewGit() {
        return new GitNestedImpl();
    }

    @Override
    public BuildSourceFluent.GitNested<T> withNewGitLike(GitBuildSource item) {
        return new GitNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.GitNested<T> editGit() {
        return this.withNewGitLike(this.getGit());
    }

    @Override
    public T withNewGit(String httpProxy, String httpsProxy, String ref, String uri) {
        return this.withGit(new GitBuildSource(httpProxy, httpsProxy, ref, uri));
    }

    @Override
    public T addToImages(ImageSource ... items) {
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.add(builder);
            this.images.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromImages(ImageSource ... items) {
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.remove(builder);
            this.images.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<ImageSource> getImages() {
        return this.build(this.images);
    }

    @Override
    public T withImages(List<ImageSource> images) {
        this.images.clear();
        if (images != null) {
            for (ImageSource item : images) {
                this.addToImages(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withImages(ImageSource ... images) {
        this.images.clear();
        if (images != null) {
            for (ImageSource item : images) {
                this.addToImages(item);
            }
        }
        return (T)this;
    }

    @Override
    public BuildSourceFluent.ImagesNested<T> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public BuildSourceFluent.ImagesNested<T> addNewImageLike(ImageSource item) {
        return new ImagesNestedImpl(item);
    }

    @Override
    public T addToSecrets(SecretBuildSource ... items) {
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.add(builder);
            this.secrets.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromSecrets(SecretBuildSource ... items) {
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.remove(builder);
            this.secrets.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<SecretBuildSource> getSecrets() {
        return this.build(this.secrets);
    }

    @Override
    public T withSecrets(List<SecretBuildSource> secrets) {
        this.secrets.clear();
        if (secrets != null) {
            for (SecretBuildSource item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withSecrets(SecretBuildSource ... secrets) {
        this.secrets.clear();
        if (secrets != null) {
            for (SecretBuildSource item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (T)this;
    }

    @Override
    public BuildSourceFluent.SecretsNested<T> addNewSecret() {
        return new SecretsNestedImpl();
    }

    @Override
    public BuildSourceFluent.SecretsNested<T> addNewSecretLike(SecretBuildSource item) {
        return new SecretsNestedImpl(item);
    }

    @Override
    public LocalObjectReference getSourceSecret() {
        return this.sourceSecret != null ? (LocalObjectReference)this.sourceSecret.build() : null;
    }

    @Override
    public T withSourceSecret(LocalObjectReference sourceSecret) {
        if (sourceSecret != null) {
            this.sourceSecret = new LocalObjectReferenceBuilder(sourceSecret);
            this._visitables.add(this.sourceSecret);
        }
        return (T)this;
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<T> withNewSourceSecret() {
        return new SourceSecretNestedImpl();
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<T> withNewSourceSecretLike(LocalObjectReference item) {
        return new SourceSecretNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<T> editSourceSecret() {
        return this.withNewSourceSecretLike(this.getSourceSecret());
    }

    @Override
    public T withNewSourceSecret(String name) {
        return this.withSourceSecret(new LocalObjectReference(name));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public T withType(String type) {
        this.type = type;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildSourceFluentImpl that = (BuildSourceFluentImpl)o;
        if (this.binary != null ? !this.binary.equals(that.binary) : that.binary != null) {
            return false;
        }
        if (this.contextDir != null ? !this.contextDir.equals(that.contextDir) : that.contextDir != null) {
            return false;
        }
        if (this.dockerfile != null ? !this.dockerfile.equals(that.dockerfile) : that.dockerfile != null) {
            return false;
        }
        if (this.git != null ? !this.git.equals(that.git) : that.git != null) {
            return false;
        }
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) {
            return false;
        }
        if (this.sourceSecret != null ? !this.sourceSecret.equals(that.sourceSecret) : that.sourceSecret != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SourceSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<BuildSourceFluent.SourceSecretNested<N>>
    implements BuildSourceFluent.SourceSecretNested<N> {
        private final LocalObjectReferenceBuilder builder;

        SourceSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        SourceSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withSourceSecret(this.builder.build());
        }

        @Override
        public N endSourceSecret() {
            return this.and();
        }
    }

    public class SecretsNestedImpl<N>
    extends SecretBuildSourceFluentImpl<BuildSourceFluent.SecretsNested<N>>
    implements BuildSourceFluent.SecretsNested<N> {
        private final SecretBuildSourceBuilder builder;

        SecretsNestedImpl() {
            this.builder = new SecretBuildSourceBuilder(this);
        }

        SecretsNestedImpl(SecretBuildSource item) {
            this.builder = new SecretBuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.addToSecrets(this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }

    public class ImagesNestedImpl<N>
    extends ImageSourceFluentImpl<BuildSourceFluent.ImagesNested<N>>
    implements BuildSourceFluent.ImagesNested<N> {
        private final ImageSourceBuilder builder;

        ImagesNestedImpl() {
            this.builder = new ImageSourceBuilder(this);
        }

        ImagesNestedImpl(ImageSource item) {
            this.builder = new ImageSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.addToImages(this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }

    public class GitNestedImpl<N>
    extends GitBuildSourceFluentImpl<BuildSourceFluent.GitNested<N>>
    implements BuildSourceFluent.GitNested<N> {
        private final GitBuildSourceBuilder builder;

        GitNestedImpl() {
            this.builder = new GitBuildSourceBuilder(this);
        }

        GitNestedImpl(GitBuildSource item) {
            this.builder = new GitBuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withGit(this.builder.build());
        }

        @Override
        public N endGit() {
            return this.and();
        }
    }

    public class BinaryNestedImpl<N>
    extends BinaryBuildSourceFluentImpl<BuildSourceFluent.BinaryNested<N>>
    implements BuildSourceFluent.BinaryNested<N> {
        private final BinaryBuildSourceBuilder builder;

        BinaryNestedImpl() {
            this.builder = new BinaryBuildSourceBuilder(this);
        }

        BinaryNestedImpl(BinaryBuildSource item) {
            this.builder = new BinaryBuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withBinary(this.builder.build());
        }

        @Override
        public N endBinary() {
            return this.and();
        }
    }
}

