/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputBuilder;
import io.fabric8.openshift.api.model.BuildOutputFluentImpl;
import io.fabric8.openshift.api.model.BuildPostCommitSpec;
import io.fabric8.openshift.api.model.BuildPostCommitSpecBuilder;
import io.fabric8.openshift.api.model.BuildPostCommitSpecFluentImpl;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSourceBuilder;
import io.fabric8.openshift.api.model.BuildSourceFluentImpl;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluentImpl;
import io.fabric8.openshift.api.model.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluentImpl;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.api.model.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.SourceRevisionFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildConfigSpecFluentImpl<T extends BuildConfigSpecFluent<T>>
extends BaseFluent<T>
implements BuildConfigSpecFluent<T> {
    Long completionDeadlineSeconds;
    VisitableBuilder<BuildOutput, ?> output;
    VisitableBuilder<BuildPostCommitSpec, ?> postCommit;
    VisitableBuilder<ResourceRequirements, ?> resources;
    VisitableBuilder<SourceRevision, ?> revision;
    String serviceAccount;
    VisitableBuilder<BuildSource, ?> source;
    VisitableBuilder<BuildStrategy, ?> strategy;
    List<VisitableBuilder<BuildTriggerPolicy, ?>> triggers = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildConfigSpecFluentImpl() {
    }

    public BuildConfigSpecFluentImpl(BuildConfigSpec instance) {
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withOutput(instance.getOutput());
        this.withPostCommit(instance.getPostCommit());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
        this.withTriggers(instance.getTriggers());
    }

    @Override
    public Long getCompletionDeadlineSeconds() {
        return this.completionDeadlineSeconds;
    }

    @Override
    public T withCompletionDeadlineSeconds(Long completionDeadlineSeconds) {
        this.completionDeadlineSeconds = completionDeadlineSeconds;
        return (T)this;
    }

    @Override
    public BuildOutput getOutput() {
        return this.output != null ? (BuildOutput)this.output.build() : null;
    }

    @Override
    public T withOutput(BuildOutput output) {
        if (output != null) {
            this.output = new BuildOutputBuilder(output);
            this._visitables.add(this.output);
        }
        return (T)this;
    }

    @Override
    public BuildConfigSpecFluent.OutputNested<T> withNewOutput() {
        return new OutputNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.OutputNested<T> withNewOutputLike(BuildOutput item) {
        return new OutputNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.OutputNested<T> editOutput() {
        return this.withNewOutputLike(this.getOutput());
    }

    @Override
    public BuildPostCommitSpec getPostCommit() {
        return this.postCommit != null ? (BuildPostCommitSpec)this.postCommit.build() : null;
    }

    @Override
    public T withPostCommit(BuildPostCommitSpec postCommit) {
        if (postCommit != null) {
            this.postCommit = new BuildPostCommitSpecBuilder(postCommit);
            this._visitables.add(this.postCommit);
        }
        return (T)this;
    }

    @Override
    public BuildConfigSpecFluent.PostCommitNested<T> withNewPostCommit() {
        return new PostCommitNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.PostCommitNested<T> withNewPostCommitLike(BuildPostCommitSpec item) {
        return new PostCommitNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.PostCommitNested<T> editPostCommit() {
        return this.withNewPostCommitLike(this.getPostCommit());
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources != null ? (ResourceRequirements)this.resources.build() : null;
    }

    @Override
    public T withResources(ResourceRequirements resources) {
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (T)this;
    }

    @Override
    public BuildConfigSpecFluent.ResourcesNested<T> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.ResourcesNested<T> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.ResourcesNested<T> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public SourceRevision getRevision() {
        return this.revision != null ? (SourceRevision)this.revision.build() : null;
    }

    @Override
    public T withRevision(SourceRevision revision) {
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.add(this.revision);
        }
        return (T)this;
    }

    @Override
    public BuildConfigSpecFluent.RevisionNested<T> withNewRevision() {
        return new RevisionNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.RevisionNested<T> withNewRevisionLike(SourceRevision item) {
        return new RevisionNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.RevisionNested<T> editRevision() {
        return this.withNewRevisionLike(this.getRevision());
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public T withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (T)this;
    }

    @Override
    public BuildSource getSource() {
        return this.source != null ? (BuildSource)this.source.build() : null;
    }

    @Override
    public T withSource(BuildSource source) {
        if (source != null) {
            this.source = new BuildSourceBuilder(source);
            this._visitables.add(this.source);
        }
        return (T)this;
    }

    @Override
    public BuildConfigSpecFluent.SourceNested<T> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.SourceNested<T> withNewSourceLike(BuildSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.SourceNested<T> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public BuildStrategy getStrategy() {
        return this.strategy != null ? (BuildStrategy)this.strategy.build() : null;
    }

    @Override
    public T withStrategy(BuildStrategy strategy) {
        if (strategy != null) {
            this.strategy = new BuildStrategyBuilder(strategy);
            this._visitables.add(this.strategy);
        }
        return (T)this;
    }

    @Override
    public BuildConfigSpecFluent.StrategyNested<T> withNewStrategy() {
        return new StrategyNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.StrategyNested<T> withNewStrategyLike(BuildStrategy item) {
        return new StrategyNestedImpl(item);
    }

    @Override
    public BuildConfigSpecFluent.StrategyNested<T> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    @Override
    public T addToTriggers(BuildTriggerPolicy ... items) {
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.add(builder);
            this.triggers.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromTriggers(BuildTriggerPolicy ... items) {
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.remove(builder);
            this.triggers.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<BuildTriggerPolicy> getTriggers() {
        return this.build(this.triggers);
    }

    @Override
    public T withTriggers(List<BuildTriggerPolicy> triggers) {
        this.triggers.clear();
        if (triggers != null) {
            for (BuildTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withTriggers(BuildTriggerPolicy ... triggers) {
        this.triggers.clear();
        if (triggers != null) {
            for (BuildTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (T)this;
    }

    @Override
    public BuildConfigSpecFluent.TriggersNested<T> addNewTrigger() {
        return new TriggersNestedImpl();
    }

    @Override
    public BuildConfigSpecFluent.TriggersNested<T> addNewTriggerLike(BuildTriggerPolicy item) {
        return new TriggersNestedImpl(item);
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildConfigSpecFluentImpl that = (BuildConfigSpecFluentImpl)o;
        if (this.completionDeadlineSeconds != null ? !this.completionDeadlineSeconds.equals(that.completionDeadlineSeconds) : that.completionDeadlineSeconds != null) {
            return false;
        }
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        if (this.postCommit != null ? !this.postCommit.equals(that.postCommit) : that.postCommit != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        if (this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class TriggersNestedImpl<N>
    extends BuildTriggerPolicyFluentImpl<BuildConfigSpecFluent.TriggersNested<N>>
    implements BuildConfigSpecFluent.TriggersNested<N> {
        private final BuildTriggerPolicyBuilder builder;

        TriggersNestedImpl() {
            this.builder = new BuildTriggerPolicyBuilder(this);
        }

        TriggersNestedImpl(BuildTriggerPolicy item) {
            this.builder = new BuildTriggerPolicyBuilder(this, item);
        }

        @Override
        public N endTrigger() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.addToTriggers(this.builder.build());
        }
    }

    public class StrategyNestedImpl<N>
    extends BuildStrategyFluentImpl<BuildConfigSpecFluent.StrategyNested<N>>
    implements BuildConfigSpecFluent.StrategyNested<N> {
        private final BuildStrategyBuilder builder;

        StrategyNestedImpl() {
            this.builder = new BuildStrategyBuilder(this);
        }

        StrategyNestedImpl(BuildStrategy item) {
            this.builder = new BuildStrategyBuilder(this, item);
        }

        @Override
        public N endStrategy() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withStrategy(this.builder.build());
        }
    }

    public class SourceNestedImpl<N>
    extends BuildSourceFluentImpl<BuildConfigSpecFluent.SourceNested<N>>
    implements BuildConfigSpecFluent.SourceNested<N> {
        private final BuildSourceBuilder builder;

        SourceNestedImpl() {
            this.builder = new BuildSourceBuilder(this);
        }

        SourceNestedImpl(BuildSource item) {
            this.builder = new BuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    public class RevisionNestedImpl<N>
    extends SourceRevisionFluentImpl<BuildConfigSpecFluent.RevisionNested<N>>
    implements BuildConfigSpecFluent.RevisionNested<N> {
        private final SourceRevisionBuilder builder;

        RevisionNestedImpl() {
            this.builder = new SourceRevisionBuilder(this);
        }

        RevisionNestedImpl(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        @Override
        public N endRevision() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withRevision(this.builder.build());
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<BuildConfigSpecFluent.ResourcesNested<N>>
    implements BuildConfigSpecFluent.ResourcesNested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class PostCommitNestedImpl<N>
    extends BuildPostCommitSpecFluentImpl<BuildConfigSpecFluent.PostCommitNested<N>>
    implements BuildConfigSpecFluent.PostCommitNested<N> {
        private final BuildPostCommitSpecBuilder builder;

        PostCommitNestedImpl() {
            this.builder = new BuildPostCommitSpecBuilder(this);
        }

        PostCommitNestedImpl(BuildPostCommitSpec item) {
            this.builder = new BuildPostCommitSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withPostCommit(this.builder.build());
        }

        @Override
        public N endPostCommit() {
            return this.and();
        }
    }

    public class OutputNestedImpl<N>
    extends BuildOutputFluentImpl<BuildConfigSpecFluent.OutputNested<N>>
    implements BuildConfigSpecFluent.OutputNested<N> {
        private final BuildOutputBuilder builder;

        OutputNestedImpl() {
            this.builder = new BuildOutputBuilder(this);
        }

        OutputNestedImpl(BuildOutput item) {
            this.builder = new BuildOutputBuilder(this, item);
        }

        @Override
        public N endOutput() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluentImpl.this.withOutput(this.builder.build());
        }
    }
}

