/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.FlexVolumeSource;
import io.fabric8.kubernetes.api.model.FlexVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class FlexVolumeSourceFluentImpl<T extends FlexVolumeSourceFluent<T>>
extends BaseFluent<T>
implements FlexVolumeSourceFluent<T> {
    String driver;
    String fsType;
    Map<String, String> options = new HashMap<String, String>();
    Boolean readOnly;
    VisitableBuilder<LocalObjectReference, ?> secretRef;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public FlexVolumeSourceFluentImpl() {
    }

    public FlexVolumeSourceFluentImpl(FlexVolumeSource instance) {
        this.withDriver(instance.getDriver());
        this.withFsType(instance.getFsType());
        this.withOptions(instance.getOptions());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public T withDriver(String driver) {
        this.driver = driver;
        return (T)this;
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public T withFsType(String fsType) {
        this.fsType = fsType;
        return (T)this;
    }

    @Override
    public T addToOptions(String key, String value) {
        if (key != null && value != null) {
            this.options.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToOptions(Map<String, String> map) {
        if (map != null) {
            this.options.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromOptions(String key) {
        if (key != null) {
            this.options.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromOptions(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.options.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public T withOptions(Map<String, String> options) {
        this.options.clear();
        if (options != null) {
            this.options.putAll(options);
        }
        return (T)this;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public T withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (T)this;
    }

    @Override
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? (LocalObjectReference)this.secretRef.build() : null;
    }

    @Override
    public T withSecretRef(LocalObjectReference secretRef) {
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.add(this.secretRef);
        }
        return (T)this;
    }

    @Override
    public FlexVolumeSourceFluent.SecretRefNested<T> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public FlexVolumeSourceFluent.SecretRefNested<T> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public FlexVolumeSourceFluent.SecretRefNested<T> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public T withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlexVolumeSourceFluentImpl that = (FlexVolumeSourceFluentImpl)o;
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(that.options) : that.options != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<FlexVolumeSourceFluent.SecretRefNested<N>>
    implements FlexVolumeSourceFluent.SecretRefNested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)FlexVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }
    }
}

