/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetList;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetListFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.EditableDaemonSetList;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DaemonSetListBuilder
extends DaemonSetListFluentImpl<DaemonSetListBuilder>
implements VisitableBuilder<DaemonSetList, DaemonSetListBuilder> {
    DaemonSetListFluent<?> fluent;

    public DaemonSetListBuilder() {
        this(new DaemonSetList());
    }

    public DaemonSetListBuilder(DaemonSetListFluent<?> fluent) {
        this(fluent, new DaemonSetList());
    }

    public DaemonSetListBuilder(DaemonSetListFluent<?> fluent, DaemonSetList instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
    }

    public DaemonSetListBuilder(DaemonSetList instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public EditableDaemonSetList build() {
        EditableDaemonSetList buildable = new EditableDaemonSetList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DaemonSetListBuilder that = (DaemonSetListBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

