/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableOAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class OAuthAccessTokenBuilder
extends OAuthAccessTokenFluent<OAuthAccessTokenBuilder>
implements VisitableBuilder<OAuthAccessToken, OAuthAccessTokenBuilder> {
    OAuthAccessTokenFluent<?> fluent;

    public OAuthAccessTokenBuilder() {
        this(new OAuthAccessToken());
    }

    public OAuthAccessTokenBuilder(OAuthAccessTokenFluent<?> fluent) {
        this(fluent, new OAuthAccessToken());
    }

    public OAuthAccessTokenBuilder(OAuthAccessTokenFluent<?> fluent, OAuthAccessToken instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withAuthorizeToken(instance.getAuthorizeToken());
        fluent.withClientName(instance.getClientName());
        fluent.withExpiresIn(instance.getExpiresIn());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRedirectURI(instance.getRedirectURI());
        fluent.withRefreshToken(instance.getRefreshToken());
        fluent.withScopes(instance.getScopes());
        fluent.withUserName(instance.getUserName());
        fluent.withUserUID(instance.getUserUID());
    }

    public OAuthAccessTokenBuilder(OAuthAccessToken instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withAuthorizeToken(instance.getAuthorizeToken());
        this.withClientName(instance.getClientName());
        this.withExpiresIn(instance.getExpiresIn());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRedirectURI(instance.getRedirectURI());
        this.withRefreshToken(instance.getRefreshToken());
        this.withScopes(instance.getScopes());
        this.withUserName(instance.getUserName());
        this.withUserUID(instance.getUserUID());
    }

    @Override
    public EditableOAuthAccessToken build() {
        EditableOAuthAccessToken buildable = new EditableOAuthAccessToken(this.fluent.getApiVersion(), this.fluent.getAuthorizeToken(), this.fluent.getClientName(), this.fluent.getExpiresIn(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRedirectURI(), this.fluent.getRefreshToken(), this.fluent.getScopes(), this.fluent.getUserName(), this.fluent.getUserUID());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

