/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.RoutePort;
import io.fabric8.openshift.api.model.RoutePortBuilder;
import io.fabric8.openshift.api.model.RoutePortFluentImpl;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import io.fabric8.openshift.api.model.TLSConfig;
import io.fabric8.openshift.api.model.TLSConfigBuilder;
import io.fabric8.openshift.api.model.TLSConfigFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class RouteSpecFluentImpl<T extends RouteSpecFluent<T>>
extends BaseFluent<T>
implements RouteSpecFluent<T> {
    String host;
    String path;
    VisitableBuilder<RoutePort, ?> port;
    VisitableBuilder<TLSConfig, ?> tls;
    VisitableBuilder<ObjectReference, ?> to;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public RouteSpecFluentImpl() {
    }

    public RouteSpecFluentImpl(RouteSpec instance) {
        this.withHost(instance.getHost());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withTls(instance.getTls());
        this.withTo(instance.getTo());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public T withHost(String host) {
        this.host = host;
        return (T)this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public T withPath(String path) {
        this.path = path;
        return (T)this;
    }

    @Override
    public RoutePort getPort() {
        return this.port != null ? (RoutePort)this.port.build() : null;
    }

    @Override
    public T withPort(RoutePort port) {
        if (port != null) {
            this.port = new RoutePortBuilder(port);
            this._visitables.add(this.port);
        }
        return (T)this;
    }

    @Override
    public RouteSpecFluent.PortNested<T> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public RouteSpecFluent.PortNested<T> withNewPortLike(RoutePort item) {
        return new PortNestedImpl(item);
    }

    @Override
    public RouteSpecFluent.PortNested<T> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public TLSConfig getTls() {
        return this.tls != null ? (TLSConfig)this.tls.build() : null;
    }

    @Override
    public T withTls(TLSConfig tls) {
        if (tls != null) {
            this.tls = new TLSConfigBuilder(tls);
            this._visitables.add(this.tls);
        }
        return (T)this;
    }

    @Override
    public RouteSpecFluent.TlsNested<T> withNewTls() {
        return new TlsNestedImpl();
    }

    @Override
    public RouteSpecFluent.TlsNested<T> withNewTlsLike(TLSConfig item) {
        return new TlsNestedImpl(item);
    }

    @Override
    public RouteSpecFluent.TlsNested<T> editTls() {
        return this.withNewTlsLike(this.getTls());
    }

    @Override
    public ObjectReference getTo() {
        return this.to != null ? (ObjectReference)this.to.build() : null;
    }

    @Override
    public T withTo(ObjectReference to) {
        if (to != null) {
            this.to = new ObjectReferenceBuilder(to);
            this._visitables.add(this.to);
        }
        return (T)this;
    }

    @Override
    public RouteSpecFluent.ToNested<T> withNewTo() {
        return new ToNestedImpl();
    }

    @Override
    public RouteSpecFluent.ToNested<T> withNewToLike(ObjectReference item) {
        return new ToNestedImpl(item);
    }

    @Override
    public RouteSpecFluent.ToNested<T> editTo() {
        return this.withNewToLike(this.getTo());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteSpecFluentImpl that = (RouteSpecFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.tls != null ? !this.tls.equals(that.tls) : that.tls != null) {
            return false;
        }
        if (this.to != null ? !this.to.equals(that.to) : that.to != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ToNestedImpl<N>
    extends ObjectReferenceFluentImpl<RouteSpecFluent.ToNested<N>>
    implements RouteSpecFluent.ToNested<N> {
        private final ObjectReferenceBuilder builder;

        ToNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ToNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.withTo(this.builder.build());
        }

        @Override
        public N endTo() {
            return this.and();
        }
    }

    public class TlsNestedImpl<N>
    extends TLSConfigFluentImpl<RouteSpecFluent.TlsNested<N>>
    implements RouteSpecFluent.TlsNested<N> {
        private final TLSConfigBuilder builder;

        TlsNestedImpl() {
            this.builder = new TLSConfigBuilder(this);
        }

        TlsNestedImpl(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        @Override
        public N endTls() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.withTls(this.builder.build());
        }
    }

    public class PortNestedImpl<N>
    extends RoutePortFluentImpl<RouteSpecFluent.PortNested<N>>
    implements RouteSpecFluent.PortNested<N> {
        private final RoutePortBuilder builder;

        PortNestedImpl() {
            this.builder = new RoutePortBuilder(this);
        }

        PortNestedImpl(RoutePort item) {
            this.builder = new RoutePortBuilder(this, item);
        }

        @Override
        public N endPort() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.withPort(this.builder.build());
        }
    }
}

