/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.APIVersion;
import io.fabric8.kubernetes.api.model.extensions.APIVersionBuilder;
import io.fabric8.kubernetes.api.model.extensions.APIVersionFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThirdPartyResourceFluentImpl<T extends ThirdPartyResourceFluent<T>>
extends BaseFluent<T>
implements ThirdPartyResourceFluent<T> {
    ThirdPartyResource.ApiVersion apiVersion;
    String description;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    List<VisitableBuilder<APIVersion, ?>> versions = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ThirdPartyResourceFluentImpl() {
    }

    public ThirdPartyResourceFluentImpl(ThirdPartyResource instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withDescription(instance.getDescription());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withVersions(instance.getVersions());
    }

    @Override
    public ThirdPartyResource.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(ThirdPartyResource.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public T withDescription(String description) {
        this.description = description;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public ThirdPartyResourceFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ThirdPartyResourceFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ThirdPartyResourceFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public T addToVersions(APIVersion ... items) {
        for (APIVersion item : items) {
            APIVersionBuilder builder = new APIVersionBuilder(item);
            this._visitables.add(builder);
            this.versions.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromVersions(APIVersion ... items) {
        for (APIVersion item : items) {
            APIVersionBuilder builder = new APIVersionBuilder(item);
            this._visitables.remove(builder);
            this.versions.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<APIVersion> getVersions() {
        return this.build(this.versions);
    }

    @Override
    public T withVersions(List<APIVersion> versions) {
        this.versions.clear();
        if (versions != null) {
            for (APIVersion item : versions) {
                this.addToVersions(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withVersions(APIVersion ... versions) {
        this.versions.clear();
        if (versions != null) {
            for (APIVersion item : versions) {
                this.addToVersions(item);
            }
        }
        return (T)this;
    }

    @Override
    public ThirdPartyResourceFluent.VersionsNested<T> addNewVersion() {
        return new VersionsNestedImpl();
    }

    @Override
    public ThirdPartyResourceFluent.VersionsNested<T> addNewVersionLike(APIVersion item) {
        return new VersionsNestedImpl(item);
    }

    @Override
    public T addNewVersion(String apiGroup, String name) {
        return this.addToVersions(new APIVersion(apiGroup, name));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThirdPartyResourceFluentImpl that = (ThirdPartyResourceFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.versions != null ? !this.versions.equals(that.versions) : that.versions != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class VersionsNestedImpl<N>
    extends APIVersionFluentImpl<ThirdPartyResourceFluent.VersionsNested<N>>
    implements ThirdPartyResourceFluent.VersionsNested<N> {
        private final APIVersionBuilder builder;

        VersionsNestedImpl() {
            this.builder = new APIVersionBuilder(this);
        }

        VersionsNestedImpl(APIVersion item) {
            this.builder = new APIVersionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ThirdPartyResourceFluentImpl.this.addToVersions(this.builder.build());
        }

        @Override
        public N endVersion() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ThirdPartyResourceFluent.MetadataNested<N>>
    implements ThirdPartyResourceFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ThirdPartyResourceFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

