/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IngressSpecFluentImpl<T extends IngressSpecFluent<T>>
extends BaseFluent<T>
implements IngressSpecFluent<T> {
    VisitableBuilder<IngressBackend, ?> backend;
    List<VisitableBuilder<IngressRule, ?>> rules = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public IngressSpecFluentImpl() {
    }

    public IngressSpecFluentImpl(IngressSpec instance) {
        this.withBackend(instance.getBackend());
        this.withRules(instance.getRules());
    }

    @Override
    public IngressBackend getBackend() {
        return this.backend != null ? (IngressBackend)this.backend.build() : null;
    }

    @Override
    public T withBackend(IngressBackend backend) {
        if (backend != null) {
            this.backend = new IngressBackendBuilder(backend);
            this._visitables.add(this.backend);
        }
        return (T)this;
    }

    @Override
    public IngressSpecFluent.BackendNested<T> withNewBackend() {
        return new BackendNestedImpl();
    }

    @Override
    public IngressSpecFluent.BackendNested<T> withNewBackendLike(IngressBackend item) {
        return new BackendNestedImpl(item);
    }

    @Override
    public IngressSpecFluent.BackendNested<T> editBackend() {
        return this.withNewBackendLike(this.getBackend());
    }

    @Override
    public T addToRules(IngressRule ... items) {
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.add(builder);
            this.rules.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromRules(IngressRule ... items) {
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.remove(builder);
            this.rules.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<IngressRule> getRules() {
        return this.build(this.rules);
    }

    @Override
    public T withRules(List<IngressRule> rules) {
        this.rules.clear();
        if (rules != null) {
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withRules(IngressRule ... rules) {
        this.rules.clear();
        if (rules != null) {
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        }
        return (T)this;
    }

    @Override
    public IngressSpecFluent.RulesNested<T> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public IngressSpecFluent.RulesNested<T> addNewRuleLike(IngressRule item) {
        return new RulesNestedImpl(item);
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressSpecFluentImpl that = (IngressSpecFluentImpl)o;
        if (this.backend != null ? !this.backend.equals(that.backend) : that.backend != null) {
            return false;
        }
        if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class RulesNestedImpl<N>
    extends IngressRuleFluentImpl<IngressSpecFluent.RulesNested<N>>
    implements IngressSpecFluent.RulesNested<N> {
        private final IngressRuleBuilder builder;

        RulesNestedImpl() {
            this.builder = new IngressRuleBuilder(this);
        }

        RulesNestedImpl(IngressRule item) {
            this.builder = new IngressRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.addToRules(this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class BackendNestedImpl<N>
    extends IngressBackendFluentImpl<IngressSpecFluent.BackendNested<N>>
    implements IngressSpecFluent.BackendNested<N> {
        private final IngressBackendBuilder builder;

        BackendNestedImpl() {
            this.builder = new IngressBackendBuilder(this);
        }

        BackendNestedImpl(IngressBackend item) {
            this.builder = new IngressBackendBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.withBackend(this.builder.build());
        }

        @Override
        public N endBackend() {
            return this.and();
        }
    }
}

