/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserFluentImpl<T extends UserFluent<T>>
extends BaseFluent<T>
implements UserFluent<T> {
    User.ApiVersion apiVersion;
    String fullName;
    List<String> groups = new ArrayList<String>();
    List<String> identities = new ArrayList<String>();
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public UserFluentImpl() {
    }

    public UserFluentImpl(User instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withFullName(instance.getFullName());
        this.withGroups(instance.getGroups());
        this.withIdentities(instance.getIdentities());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public User.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(User.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public T withFullName(String fullName) {
        this.fullName = fullName;
        return (T)this;
    }

    @Override
    public T addToGroups(String ... items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromGroups(String ... items) {
        for (String item : items) {
            this.groups.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public T withGroups(List<String> groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withGroups(String ... groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (T)this;
    }

    @Override
    public T addToIdentities(String ... items) {
        for (String item : items) {
            this.identities.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromIdentities(String ... items) {
        for (String item : items) {
            this.identities.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getIdentities() {
        return this.identities;
    }

    @Override
    public T withIdentities(List<String> identities) {
        this.identities.clear();
        if (identities != null) {
            for (String item : identities) {
                this.addToIdentities(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withIdentities(String ... identities) {
        this.identities.clear();
        if (identities != null) {
            for (String item : identities) {
                this.addToIdentities(item);
            }
        }
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public UserFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public UserFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public UserFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFluentImpl that = (UserFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.fullName != null ? !this.fullName.equals(that.fullName) : that.fullName != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.identities != null ? !this.identities.equals(that.identities) : that.identities != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<UserFluent.MetadataNested<N>>
    implements UserFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)UserFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

