/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointAddressBuilder;
import io.fabric8.kubernetes.api.model.EndpointAddressFluentImpl;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointPortBuilder;
import io.fabric8.kubernetes.api.model.EndpointPortFluentImpl;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.EndpointSubsetFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EndpointSubsetFluentImpl<T extends EndpointSubsetFluent<T>>
extends BaseFluent<T>
implements EndpointSubsetFluent<T> {
    List<VisitableBuilder<EndpointAddress, ?>> addresses = new ArrayList();
    List<VisitableBuilder<EndpointAddress, ?>> notReadyAddresses = new ArrayList();
    List<VisitableBuilder<EndpointPort, ?>> ports = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public EndpointSubsetFluentImpl() {
    }

    public EndpointSubsetFluentImpl(EndpointSubset instance) {
        this.withAddresses(instance.getAddresses());
        this.withNotReadyAddresses(instance.getNotReadyAddresses());
        this.withPorts(instance.getPorts());
    }

    @Override
    public T addToAddresses(EndpointAddress ... items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.add(builder);
            this.addresses.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromAddresses(EndpointAddress ... items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.remove(builder);
            this.addresses.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<EndpointAddress> getAddresses() {
        return this.build(this.addresses);
    }

    @Override
    public T withAddresses(List<EndpointAddress> addresses) {
        this.addresses.clear();
        if (addresses != null) {
            for (EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withAddresses(EndpointAddress ... addresses) {
        this.addresses.clear();
        if (addresses != null) {
            for (EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (T)this;
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<T> addNewAddresse() {
        return new AddressesNestedImpl();
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<T> addNewAddresseLike(EndpointAddress item) {
        return new AddressesNestedImpl(item);
    }

    @Override
    public T addToNotReadyAddresses(EndpointAddress ... items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromNotReadyAddresses(EndpointAddress ... items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.remove(builder);
            this.notReadyAddresses.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<EndpointAddress> getNotReadyAddresses() {
        return this.build(this.notReadyAddresses);
    }

    @Override
    public T withNotReadyAddresses(List<EndpointAddress> notReadyAddresses) {
        this.notReadyAddresses.clear();
        if (notReadyAddresses != null) {
            for (EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withNotReadyAddresses(EndpointAddress ... notReadyAddresses) {
        this.notReadyAddresses.clear();
        if (notReadyAddresses != null) {
            for (EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        }
        return (T)this;
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<T> addNewNotReadyAddresse() {
        return new NotReadyAddressesNestedImpl();
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<T> addNewNotReadyAddresseLike(EndpointAddress item) {
        return new NotReadyAddressesNestedImpl(item);
    }

    @Override
    public T addToPorts(EndpointPort ... items) {
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromPorts(EndpointPort ... items) {
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<EndpointPort> getPorts() {
        return this.build(this.ports);
    }

    @Override
    public T withPorts(List<EndpointPort> ports) {
        this.ports.clear();
        if (ports != null) {
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withPorts(EndpointPort ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)this;
    }

    @Override
    public EndpointSubsetFluent.PortsNested<T> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public EndpointSubsetFluent.PortsNested<T> addNewPortLike(EndpointPort item) {
        return new PortsNestedImpl(item);
    }

    @Override
    public T addNewPort(String name, Integer port, String protocol) {
        return this.addToPorts(new EndpointPort(name, port, protocol));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointSubsetFluentImpl that = (EndpointSubsetFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.notReadyAddresses != null ? !this.notReadyAddresses.equals(that.notReadyAddresses) : that.notReadyAddresses != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class PortsNestedImpl<N>
    extends EndpointPortFluentImpl<EndpointSubsetFluent.PortsNested<N>>
    implements EndpointSubsetFluent.PortsNested<N> {
        private final EndpointPortBuilder builder;

        PortsNestedImpl(EndpointPort item) {
            this.builder = new EndpointPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.builder = new EndpointPortBuilder(this);
        }

        @Override
        public N endPort() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluentImpl.this.addToPorts(this.builder.build());
        }
    }

    public class NotReadyAddressesNestedImpl<N>
    extends EndpointAddressFluentImpl<EndpointSubsetFluent.NotReadyAddressesNested<N>>
    implements EndpointSubsetFluent.NotReadyAddressesNested<N> {
        private final EndpointAddressBuilder builder;

        NotReadyAddressesNestedImpl() {
            this.builder = new EndpointAddressBuilder(this);
        }

        NotReadyAddressesNestedImpl(EndpointAddress item) {
            this.builder = new EndpointAddressBuilder(this, item);
        }

        @Override
        public N endNotReadyAddresse() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluentImpl.this.addToNotReadyAddresses(this.builder.build());
        }
    }

    public class AddressesNestedImpl<N>
    extends EndpointAddressFluentImpl<EndpointSubsetFluent.AddressesNested<N>>
    implements EndpointSubsetFluent.AddressesNested<N> {
        private final EndpointAddressBuilder builder;

        AddressesNestedImpl(EndpointAddress item) {
            this.builder = new EndpointAddressBuilder(this, item);
        }

        AddressesNestedImpl() {
            this.builder = new EndpointAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluentImpl.this.addToAddresses(this.builder.build());
        }

        @Override
        public N endAddresse() {
            return this.and();
        }
    }
}

