/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "content", "groups", "kind", "namespace", "resource", "resourceName", "user", "verb"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class SubjectAccessReview {
    @JsonProperty(value="apiVersion")
    @NotNull
    private ApiVersion apiVersion = ApiVersion.fromValue("v1");
    @JsonProperty(value="content")
    @Valid
    private HasMetadata content;
    @JsonProperty(value="groups")
    @Valid
    private List<String> groups = new ArrayList<String>();
    @JsonProperty(value="kind")
    @NotNull
    private String kind = "SubjectAccessReview";
    @JsonProperty(value="namespace")
    private String namespace;
    @JsonProperty(value="resource")
    private String resource;
    @JsonProperty(value="resourceName")
    private String resourceName;
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="verb")
    private String verb;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public SubjectAccessReview() {
    }

    public SubjectAccessReview(ApiVersion apiVersion, HasMetadata content, List<String> groups, String kind, String namespace, String resource, String resourceName, String user, String verb) {
        this.apiVersion = apiVersion;
        this.content = content;
        this.groups = groups;
        this.kind = kind;
        this.namespace = namespace;
        this.resource = resource;
        this.resourceName = resourceName;
        this.user = user;
        this.verb = verb;
    }

    @JsonProperty(value="apiVersion")
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="content")
    public HasMetadata getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    public void setContent(HasMetadata content) {
        this.content = content;
    }

    @JsonProperty(value="groups")
    public List<String> getGroups() {
        return this.groups;
    }

    @JsonProperty(value="groups")
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="resource")
    public String getResource() {
        return this.resource;
    }

    @JsonProperty(value="resource")
    public void setResource(String resource) {
        this.resource = resource;
    }

    @JsonProperty(value="resourceName")
    public String getResourceName() {
        return this.resourceName;
    }

    @JsonProperty(value="resourceName")
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @JsonProperty(value="user")
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    public void setUser(String user) {
        this.user = user;
    }

    @JsonProperty(value="verb")
    public String getVerb() {
        return this.verb;
    }

    @JsonProperty(value="verb")
    public void setVerb(String verb) {
        this.verb = verb;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "SubjectAccessReview(apiVersion=" + (Object)((Object)this.getApiVersion()) + ", content=" + this.getContent() + ", groups=" + this.getGroups() + ", kind=" + this.getKind() + ", namespace=" + this.getNamespace() + ", resource=" + this.getResource() + ", resourceName=" + this.getResourceName() + ", user=" + this.getUser() + ", verb=" + this.getVerb() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubjectAccessReview)) {
            return false;
        }
        SubjectAccessReview other = (SubjectAccessReview)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApiVersion this$apiVersion = this.getApiVersion();
        ApiVersion other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !((Object)((Object)this$apiVersion)).equals((Object)other$apiVersion)) {
            return false;
        }
        HasMetadata this$content = this.getContent();
        HasMetadata other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<String> this$groups = this.getGroups();
        List<String> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$resource = this.getResource();
        String other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        String this$resourceName = this.getResourceName();
        String other$resourceName = other.getResourceName();
        if (this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$verb = this.getVerb();
        String other$verb = other.getVerb();
        if (this$verb == null ? other$verb != null : !this$verb.equals(other$verb)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubjectAccessReview;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiVersion $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 0 : ((Object)((Object)$apiVersion)).hashCode());
        HasMetadata $content = this.getContent();
        result = result * 59 + ($content == null ? 0 : $content.hashCode());
        List<String> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 0 : ((Object)$groups).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 0 : $kind.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 0 : $namespace.hashCode());
        String $resource = this.getResource();
        result = result * 59 + ($resource == null ? 0 : $resource.hashCode());
        String $resourceName = this.getResourceName();
        result = result * 59 + ($resourceName == null ? 0 : $resourceName.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 0 : $user.hashCode());
        String $verb = this.getVerb();
        result = result * 59 + ($verb == null ? 0 : $verb.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 0 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public static enum ApiVersion {
        V_1("v1");

        private final String value;
        private static Map<String, ApiVersion> constants;

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ApiVersion fromValue(String value) {
            ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, ApiVersion>();
            for (ApiVersion c : ApiVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

