/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildStatus;
import io.fabric8.openshift.api.model.BuildStatusFluent;
import io.fabric8.openshift.api.model.BuildStatusFluentImpl;
import io.fabric8.openshift.api.model.EditableBuildStatus;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildStatusBuilder
extends BuildStatusFluentImpl<BuildStatusBuilder>
implements VisitableBuilder<BuildStatus, BuildStatusBuilder> {
    BuildStatusFluent<?> fluent;

    public BuildStatusBuilder() {
        this(new BuildStatus());
    }

    public BuildStatusBuilder(BuildStatusFluent<?> fluent) {
        this(fluent, new BuildStatus());
    }

    public BuildStatusBuilder(BuildStatusFluent<?> fluent, BuildStatus instance) {
        this.fluent = fluent;
        fluent.withCancelled(instance.getCancelled());
        fluent.withCompletionTimestamp(instance.getCompletionTimestamp());
        fluent.withConfig(instance.getConfig());
        fluent.withDuration(instance.getDuration());
        fluent.withMessage(instance.getMessage());
        fluent.withPhase(instance.getPhase());
        fluent.withStartTimestamp(instance.getStartTimestamp());
    }

    public BuildStatusBuilder(BuildStatus instance) {
        this.fluent = this;
        this.withCancelled(instance.getCancelled());
        this.withCompletionTimestamp(instance.getCompletionTimestamp());
        this.withConfig(instance.getConfig());
        this.withDuration(instance.getDuration());
        this.withMessage(instance.getMessage());
        this.withPhase(instance.getPhase());
        this.withStartTimestamp(instance.getStartTimestamp());
    }

    @Override
    public EditableBuildStatus build() {
        EditableBuildStatus buildable = new EditableBuildStatus(this.fluent.isCancelled(), this.fluent.getCompletionTimestamp(), this.fluent.getConfig(), this.fluent.getDuration(), this.fluent.getMessage(), this.fluent.getPhase(), this.fluent.getStartTimestamp());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildStatusBuilder that = (BuildStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

