/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateFluent;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateRunningBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateRunningFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class ContainerStateFluentImpl<T extends ContainerStateFluent<T>>
extends BaseFluent<T>
implements ContainerStateFluent<T> {
    VisitableBuilder<ContainerStateRunning, ?> running;
    VisitableBuilder<ContainerStateTerminated, ?> terminated;
    VisitableBuilder<ContainerStateWaiting, ?> waiting;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ContainerStateFluentImpl() {
    }

    public ContainerStateFluentImpl(ContainerState instance) {
        this.withRunning(instance.getRunning());
        this.withTerminated(instance.getTerminated());
        this.withWaiting(instance.getWaiting());
    }

    @Override
    public ContainerStateRunning getRunning() {
        return this.running != null ? (ContainerStateRunning)this.running.build() : null;
    }

    @Override
    public T withRunning(ContainerStateRunning running) {
        if (running != null) {
            this.running = new ContainerStateRunningBuilder(running);
            this._visitables.add(this.running);
        }
        return (T)this;
    }

    @Override
    public ContainerStateFluent.RunningNested<T> withNewRunning() {
        return new RunningNestedImpl();
    }

    @Override
    public ContainerStateFluent.RunningNested<T> withNewRunningLike(ContainerStateRunning item) {
        return new RunningNestedImpl(item);
    }

    @Override
    public ContainerStateFluent.RunningNested<T> editRunning() {
        return this.withNewRunningLike(this.getRunning());
    }

    @Override
    public T withNewRunning(String startedAt) {
        return this.withRunning(new ContainerStateRunning(startedAt));
    }

    @Override
    public ContainerStateTerminated getTerminated() {
        return this.terminated != null ? (ContainerStateTerminated)this.terminated.build() : null;
    }

    @Override
    public T withTerminated(ContainerStateTerminated terminated) {
        if (terminated != null) {
            this.terminated = new ContainerStateTerminatedBuilder(terminated);
            this._visitables.add(this.terminated);
        }
        return (T)this;
    }

    @Override
    public ContainerStateFluent.TerminatedNested<T> withNewTerminated() {
        return new TerminatedNestedImpl();
    }

    @Override
    public ContainerStateFluent.TerminatedNested<T> withNewTerminatedLike(ContainerStateTerminated item) {
        return new TerminatedNestedImpl(item);
    }

    @Override
    public ContainerStateFluent.TerminatedNested<T> editTerminated() {
        return this.withNewTerminatedLike(this.getTerminated());
    }

    @Override
    public ContainerStateWaiting getWaiting() {
        return this.waiting != null ? (ContainerStateWaiting)this.waiting.build() : null;
    }

    @Override
    public T withWaiting(ContainerStateWaiting waiting) {
        if (waiting != null) {
            this.waiting = new ContainerStateWaitingBuilder(waiting);
            this._visitables.add(this.waiting);
        }
        return (T)this;
    }

    @Override
    public ContainerStateFluent.WaitingNested<T> withNewWaiting() {
        return new WaitingNestedImpl();
    }

    @Override
    public ContainerStateFluent.WaitingNested<T> withNewWaitingLike(ContainerStateWaiting item) {
        return new WaitingNestedImpl(item);
    }

    @Override
    public ContainerStateFluent.WaitingNested<T> editWaiting() {
        return this.withNewWaitingLike(this.getWaiting());
    }

    @Override
    public T withNewWaiting(String reason) {
        return this.withWaiting(new ContainerStateWaiting(reason));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerStateFluentImpl that = (ContainerStateFluentImpl)o;
        if (this.running != null ? !this.running.equals(that.running) : that.running != null) {
            return false;
        }
        if (this.terminated != null ? !this.terminated.equals(that.terminated) : that.terminated != null) {
            return false;
        }
        if (this.waiting != null ? !this.waiting.equals(that.waiting) : that.waiting != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class WaitingNestedImpl<N>
    extends ContainerStateWaitingFluentImpl<ContainerStateFluent.WaitingNested<N>>
    implements ContainerStateFluent.WaitingNested<N> {
        private final ContainerStateWaitingBuilder builder;

        WaitingNestedImpl(ContainerStateWaiting item) {
            this.builder = new ContainerStateWaitingBuilder(this, item);
        }

        WaitingNestedImpl() {
            this.builder = new ContainerStateWaitingBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerStateFluentImpl.this.withWaiting(this.builder.build());
        }

        @Override
        public N endWaiting() {
            return this.and();
        }
    }

    public class TerminatedNestedImpl<N>
    extends ContainerStateTerminatedFluentImpl<ContainerStateFluent.TerminatedNested<N>>
    implements ContainerStateFluent.TerminatedNested<N> {
        private final ContainerStateTerminatedBuilder builder;

        TerminatedNestedImpl() {
            this.builder = new ContainerStateTerminatedBuilder(this);
        }

        TerminatedNestedImpl(ContainerStateTerminated item) {
            this.builder = new ContainerStateTerminatedBuilder(this, item);
        }

        @Override
        public N endTerminated() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ContainerStateFluentImpl.this.withTerminated(this.builder.build());
        }
    }

    public class RunningNestedImpl<N>
    extends ContainerStateRunningFluentImpl<ContainerStateFluent.RunningNested<N>>
    implements ContainerStateFluent.RunningNested<N> {
        private final ContainerStateRunningBuilder builder;

        RunningNestedImpl() {
            this.builder = new ContainerStateRunningBuilder(this);
        }

        RunningNestedImpl(ContainerStateRunning item) {
            this.builder = new ContainerStateRunningBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerStateFluentImpl.this.withRunning(this.builder.build());
        }

        @Override
        public N endRunning() {
            return this.and();
        }
    }
}

