/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceAccountFluentImpl<T extends ServiceAccountFluent<T>>
extends BaseFluent<T>
implements ServiceAccountFluent<T> {
    ServiceAccount.ApiVersion apiVersion;
    List<VisitableBuilder<LocalObjectReference, ?>> imagePullSecrets = new ArrayList();
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    List<VisitableBuilder<ObjectReference, ?>> secrets = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    public ServiceAccount.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(ServiceAccount.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public T addToImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<LocalObjectReference> getImagePullSecrets() {
        return this.build(this.imagePullSecrets);
    }

    @Override
    public T withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets.clear();
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        this.imagePullSecrets.clear();
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (T)this;
    }

    @Override
    public ServiceAccountFluent.ImagePullSecretsNested<T> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    @Override
    public ServiceAccountFluent.ImagePullSecretsNested<T> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(item);
    }

    @Override
    public T addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public ServiceAccountFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ServiceAccountFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ServiceAccountFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public T addToSecrets(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.secrets.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromSecrets(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.secrets.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<ObjectReference> getSecrets() {
        return this.build(this.secrets);
    }

    @Override
    public T withSecrets(List<ObjectReference> secrets) {
        this.secrets.clear();
        if (secrets != null) {
            for (ObjectReference item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withSecrets(ObjectReference ... secrets) {
        this.secrets.clear();
        if (secrets != null) {
            for (ObjectReference item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (T)this;
    }

    @Override
    public ServiceAccountFluent.SecretsNested<T> addNewSecret() {
        return new SecretsNestedImpl();
    }

    @Override
    public ServiceAccountFluent.SecretsNested<T> addNewSecretLike(ObjectReference item) {
        return new SecretsNestedImpl(item);
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceAccountFluentImpl that = (ServiceAccountFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SecretsNestedImpl<N>
    extends ObjectReferenceFluentImpl<ServiceAccountFluent.SecretsNested<N>>
    implements ServiceAccountFluent.SecretsNested<N> {
        private final ObjectReferenceBuilder builder;

        SecretsNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        SecretsNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ServiceAccountFluentImpl.this.addToSecrets(this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ServiceAccountFluent.MetadataNested<N>>
    implements ServiceAccountFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ServiceAccountFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ImagePullSecretsNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ServiceAccountFluent.ImagePullSecretsNested<N>>
    implements ServiceAccountFluent.ImagePullSecretsNested<N> {
        private final LocalObjectReferenceBuilder builder;

        ImagePullSecretsNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        ImagePullSecretsNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ServiceAccountFluentImpl.this.addToImagePullSecrets(this.builder.build());
        }

        @Override
        public N endImagePullSecret() {
            return this.and();
        }
    }
}

