/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatus;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatusBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class ResourceQuotaFluentImpl<T extends ResourceQuotaFluent<T>>
extends BaseFluent<T>
implements ResourceQuotaFluent<T> {
    ResourceQuota.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<ResourceQuotaSpec, ?> spec;
    VisitableBuilder<ResourceQuotaStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    public ResourceQuota.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(ResourceQuota.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public ResourceQuotaFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ResourceQuotaFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ResourceQuotaFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ResourceQuotaSpec getSpec() {
        return this.spec != null ? (ResourceQuotaSpec)this.spec.build() : null;
    }

    @Override
    public T withSpec(ResourceQuotaSpec spec) {
        if (spec != null) {
            this.spec = new ResourceQuotaSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    @Override
    public ResourceQuotaFluent.SpecNested<T> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ResourceQuotaFluent.SpecNested<T> withNewSpecLike(ResourceQuotaSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ResourceQuotaFluent.SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ResourceQuotaStatus getStatus() {
        return this.status != null ? (ResourceQuotaStatus)this.status.build() : null;
    }

    @Override
    public T withStatus(ResourceQuotaStatus status) {
        if (status != null) {
            this.status = new ResourceQuotaStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    @Override
    public ResourceQuotaFluent.StatusNested<T> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ResourceQuotaFluent.StatusNested<T> withNewStatusLike(ResourceQuotaStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ResourceQuotaFluent.StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceQuotaFluentImpl that = (ResourceQuotaFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StatusNestedImpl<N>
    extends ResourceQuotaStatusFluentImpl<ResourceQuotaFluent.StatusNested<N>>
    implements ResourceQuotaFluent.StatusNested<N> {
        private final ResourceQuotaStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new ResourceQuotaStatusBuilder(this);
        }

        StatusNestedImpl(ResourceQuotaStatus item) {
            this.builder = new ResourceQuotaStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceQuotaFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ResourceQuotaSpecFluentImpl<ResourceQuotaFluent.SpecNested<N>>
    implements ResourceQuotaFluent.SpecNested<N> {
        private final ResourceQuotaSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new ResourceQuotaSpecBuilder(this);
        }

        SpecNestedImpl(ResourceQuotaSpec item) {
            this.builder = new ResourceQuotaSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ResourceQuotaFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ResourceQuotaFluent.MetadataNested<N>>
    implements ResourceQuotaFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceQuotaFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

