/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ContainerStatusBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatusFluentImpl;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodConditionBuilder;
import io.fabric8.kubernetes.api.model.PodConditionFluentImpl;
import io.fabric8.kubernetes.api.model.PodStatusFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PodStatusFluentImpl<T extends PodStatusFluent<T>>
extends BaseFluent<T>
implements PodStatusFluent<T> {
    List<VisitableBuilder<PodCondition, ?>> conditions = new ArrayList();
    List<VisitableBuilder<ContainerStatus, ?>> containerStatuses = new ArrayList();
    String hostIP;
    String message;
    String phase;
    String podIP;
    String reason;
    String startTime;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    public T addToConditions(PodCondition ... items) {
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromConditions(PodCondition ... items) {
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<PodCondition> getConditions() {
        return this.build(this.conditions);
    }

    @Override
    public T withConditions(List<PodCondition> conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withConditions(PodCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (T)this;
    }

    @Override
    public PodStatusFluent.ConditionsNested<T> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public PodStatusFluent.ConditionsNested<T> addNewConditionLike(PodCondition item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public T addNewCondition(String status, String type) {
        return this.addToConditions(new PodCondition(status, type));
    }

    @Override
    public T addToContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.add(builder);
            this.containerStatuses.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.remove(builder);
            this.containerStatuses.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<ContainerStatus> getContainerStatuses() {
        return this.build(this.containerStatuses);
    }

    @Override
    public T withContainerStatuses(List<ContainerStatus> containerStatuses) {
        this.containerStatuses.clear();
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withContainerStatuses(ContainerStatus ... containerStatuses) {
        this.containerStatuses.clear();
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (T)this;
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<T> addNewContainerStatuse() {
        return new ContainerStatusesNestedImpl();
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<T> addNewContainerStatuseLike(ContainerStatus item) {
        return new ContainerStatusesNestedImpl(item);
    }

    @Override
    public String getHostIP() {
        return this.hostIP;
    }

    @Override
    public T withHostIP(String hostIP) {
        this.hostIP = hostIP;
        return (T)this;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public T withMessage(String message) {
        this.message = message;
        return (T)this;
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public T withPhase(String phase) {
        this.phase = phase;
        return (T)this;
    }

    @Override
    public String getPodIP() {
        return this.podIP;
    }

    @Override
    public T withPodIP(String podIP) {
        this.podIP = podIP;
        return (T)this;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public T withReason(String reason) {
        this.reason = reason;
        return (T)this;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public T withStartTime(String startTime) {
        this.startTime = startTime;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodStatusFluentImpl that = (PodStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.containerStatuses != null ? !this.containerStatuses.equals(that.containerStatuses) : that.containerStatuses != null) {
            return false;
        }
        if (this.hostIP != null ? !this.hostIP.equals(that.hostIP) : that.hostIP != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.podIP != null ? !this.podIP.equals(that.podIP) : that.podIP != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ContainerStatusesNestedImpl<N>
    extends ContainerStatusFluentImpl<PodStatusFluent.ContainerStatusesNested<N>>
    implements PodStatusFluent.ContainerStatusesNested<N> {
        private final ContainerStatusBuilder builder;

        ContainerStatusesNestedImpl() {
            this.builder = new ContainerStatusBuilder(this);
        }

        ContainerStatusesNestedImpl(ContainerStatus item) {
            this.builder = new ContainerStatusBuilder(this, item);
        }

        @Override
        public N endContainerStatuse() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PodStatusFluentImpl.this.addToContainerStatuses(this.builder.build());
        }
    }

    public class ConditionsNestedImpl<N>
    extends PodConditionFluentImpl<PodStatusFluent.ConditionsNested<N>>
    implements PodStatusFluent.ConditionsNested<N> {
        private final PodConditionBuilder builder;

        ConditionsNestedImpl() {
            this.builder = new PodConditionBuilder(this);
        }

        ConditionsNestedImpl(PodCondition item) {
            this.builder = new PodConditionBuilder(this, item);
        }

        @Override
        public N endCondition() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PodStatusFluentImpl.this.addToConditions(this.builder.build());
        }
    }
}

