/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ISCSIVolumeSourceBuilder
extends ISCSIVolumeSourceFluent<ISCSIVolumeSourceBuilder>
implements VisitableBuilder<ISCSIVolumeSource, ISCSIVolumeSourceBuilder> {
    ISCSIVolumeSourceFluent<?> fluent;

    public ISCSIVolumeSourceBuilder() {
        this(new ISCSIVolumeSource());
    }

    public ISCSIVolumeSourceBuilder(ISCSIVolumeSourceFluent<?> fluent) {
        this(fluent, new ISCSIVolumeSource());
    }

    public ISCSIVolumeSourceBuilder(ISCSIVolumeSourceFluent<?> fluent, ISCSIVolumeSource instance) {
        this.fluent = fluent;
        fluent.withFsType(instance.getFsType());
        fluent.withIqn(instance.getIqn());
        fluent.withLun(instance.getLun());
        fluent.withReadOnly(instance.getReadOnly());
        fluent.withTargetPortal(instance.getTargetPortal());
    }

    public ISCSIVolumeSourceBuilder(ISCSIVolumeSource instance) {
        this.fluent = this;
        this.withFsType(instance.getFsType());
        this.withIqn(instance.getIqn());
        this.withLun(instance.getLun());
        this.withReadOnly(instance.getReadOnly());
        this.withTargetPortal(instance.getTargetPortal());
    }

    @Override
    public EditableISCSIVolumeSource build() {
        EditableISCSIVolumeSource buildable = new EditableISCSIVolumeSource(this.fluent.getFsType(), this.fluent.getIqn(), this.fluent.getLun(), this.fluent.isReadOnly(), this.fluent.getTargetPortal());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ISCSIVolumeSourceBuilder that = (ISCSIVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

