/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluent;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedClusterBuilder;
import io.fabric8.kubernetes.api.model.NamedClusterFluent;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextBuilder;
import io.fabric8.kubernetes.api.model.NamedContextFluent;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluent;
import io.fabric8.kubernetes.api.model.Preferences;
import io.fabric8.kubernetes.api.model.PreferencesBuilder;
import io.fabric8.kubernetes.api.model.PreferencesFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigFluent<T extends ConfigFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    String apiVersion;
    List<VisitableBuilder<NamedCluster, ?>> clusters = new ArrayList();
    List<VisitableBuilder<NamedContext, ?>> contexts = new ArrayList();
    String currentContext;
    List<VisitableBuilder<NamedExtension, ?>> extensions = new ArrayList();
    String kind;
    VisitableBuilder<Preferences, ?> preferences;
    List<VisitableBuilder<NamedAuthInfo, ?>> users = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public String getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public T addToClusters(NamedCluster ... items) {
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.add(builder);
            this.clusters.add(builder);
        }
        return (T)this;
    }

    public T removeFromClusters(NamedCluster ... items) {
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.remove(builder);
            this.clusters.remove(builder);
        }
        return (T)this;
    }

    public List<NamedCluster> getClusters() {
        return this.build(this.clusters);
    }

    public T withClusters(List<NamedCluster> clusters) {
        this.clusters.clear();
        if (clusters != null) {
            for (NamedCluster item : clusters) {
                this.addToClusters(item);
            }
        }
        return (T)this;
    }

    public T withClusters(NamedCluster ... clusters) {
        this.clusters.clear();
        if (clusters != null) {
            for (NamedCluster item : clusters) {
                this.addToClusters(item);
            }
        }
        return (T)this;
    }

    public ClustersNested<T> addNewCluster() {
        return new ClustersNested();
    }

    public ClustersNested<T> addNewClusterLike(NamedCluster item) {
        return new ClustersNested(item);
    }

    public T addToContexts(NamedContext ... items) {
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.add(builder);
            this.contexts.add(builder);
        }
        return (T)this;
    }

    public T removeFromContexts(NamedContext ... items) {
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.remove(builder);
            this.contexts.remove(builder);
        }
        return (T)this;
    }

    public List<NamedContext> getContexts() {
        return this.build(this.contexts);
    }

    public T withContexts(List<NamedContext> contexts) {
        this.contexts.clear();
        if (contexts != null) {
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        }
        return (T)this;
    }

    public T withContexts(NamedContext ... contexts) {
        this.contexts.clear();
        if (contexts != null) {
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        }
        return (T)this;
    }

    public ContextsNested<T> addNewContext() {
        return new ContextsNested();
    }

    public ContextsNested<T> addNewContextLike(NamedContext item) {
        return new ContextsNested(item);
    }

    public String getCurrentContext() {
        return this.currentContext;
    }

    public T withCurrentContext(String currentContext) {
        this.currentContext = currentContext;
        return (T)this;
    }

    public T addToExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.add(builder);
            this.extensions.add(builder);
        }
        return (T)this;
    }

    public T removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.remove(builder);
            this.extensions.remove(builder);
        }
        return (T)this;
    }

    public List<NamedExtension> getExtensions() {
        return this.build(this.extensions);
    }

    public T withExtensions(List<NamedExtension> extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (T)this;
    }

    public T withExtensions(NamedExtension ... extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (T)this;
    }

    public ExtensionsNested<T> addNewExtension() {
        return new ExtensionsNested();
    }

    public ExtensionsNested<T> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNested(item);
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public Preferences getPreferences() {
        return this.preferences != null ? (Preferences)this.preferences.build() : null;
    }

    public T withPreferences(Preferences preferences) {
        if (preferences != null) {
            this.preferences = new PreferencesBuilder(preferences);
            this._visitables.add(this.preferences);
        }
        return (T)this;
    }

    public PreferencesNested<T> withNewPreferences() {
        return new PreferencesNested();
    }

    public PreferencesNested<T> withNewPreferencesLike(Preferences item) {
        return new PreferencesNested(item);
    }

    public PreferencesNested<T> editPreferences() {
        return this.withNewPreferencesLike(this.getPreferences());
    }

    public T addToUsers(NamedAuthInfo ... items) {
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.add(builder);
            this.users.add(builder);
        }
        return (T)this;
    }

    public T removeFromUsers(NamedAuthInfo ... items) {
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.remove(builder);
            this.users.remove(builder);
        }
        return (T)this;
    }

    public List<NamedAuthInfo> getUsers() {
        return this.build(this.users);
    }

    public T withUsers(List<NamedAuthInfo> users) {
        this.users.clear();
        if (users != null) {
            for (NamedAuthInfo item : users) {
                this.addToUsers(item);
            }
        }
        return (T)this;
    }

    public T withUsers(NamedAuthInfo ... users) {
        this.users.clear();
        if (users != null) {
            for (NamedAuthInfo item : users) {
                this.addToUsers(item);
            }
        }
        return (T)this;
    }

    public UsersNested<T> addNewUser() {
        return new UsersNested();
    }

    public UsersNested<T> addNewUserLike(NamedAuthInfo item) {
        return new UsersNested(item);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigFluent that = (ConfigFluent)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.clusters != null ? !this.clusters.equals(that.clusters) : that.clusters != null) {
            return false;
        }
        if (this.contexts != null ? !this.contexts.equals(that.contexts) : that.contexts != null) {
            return false;
        }
        if (this.currentContext != null ? !this.currentContext.equals(that.currentContext) : that.currentContext != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.preferences != null ? !this.preferences.equals(that.preferences) : that.preferences != null) {
            return false;
        }
        if (this.users != null ? !this.users.equals(that.users) : that.users != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class UsersNested<N>
    extends NamedAuthInfoFluent<UsersNested<N>>
    implements Nested<N> {
        private final NamedAuthInfoBuilder builder;

        UsersNested() {
            this.builder = new NamedAuthInfoBuilder(this);
        }

        UsersNested(NamedAuthInfo item) {
            this.builder = new NamedAuthInfoBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConfigFluent.this.addToUsers(this.builder.build());
        }

        public N endUser() {
            return this.and();
        }
    }

    public class PreferencesNested<N>
    extends PreferencesFluent<PreferencesNested<N>>
    implements Nested<N> {
        private final PreferencesBuilder builder;

        PreferencesNested() {
            this.builder = new PreferencesBuilder(this);
        }

        PreferencesNested(Preferences item) {
            this.builder = new PreferencesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConfigFluent.this.withPreferences(this.builder.build());
        }

        public N endPreferences() {
            return this.and();
        }
    }

    public class ExtensionsNested<N>
    extends NamedExtensionFluent<ExtensionsNested<N>>
    implements Nested<N> {
        private final NamedExtensionBuilder builder;

        ExtensionsNested() {
            this.builder = new NamedExtensionBuilder(this);
        }

        ExtensionsNested(NamedExtension item) {
            this.builder = new NamedExtensionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConfigFluent.this.addToExtensions(this.builder.build());
        }

        public N endExtension() {
            return this.and();
        }
    }

    public class ContextsNested<N>
    extends NamedContextFluent<ContextsNested<N>>
    implements Nested<N> {
        private final NamedContextBuilder builder;

        ContextsNested() {
            this.builder = new NamedContextBuilder(this);
        }

        ContextsNested(NamedContext item) {
            this.builder = new NamedContextBuilder(this, item);
        }

        public N endContext() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ConfigFluent.this.addToContexts(this.builder.build());
        }
    }

    public class ClustersNested<N>
    extends NamedClusterFluent<ClustersNested<N>>
    implements Nested<N> {
        private final NamedClusterBuilder builder;

        ClustersNested() {
            this.builder = new NamedClusterBuilder(this);
        }

        ClustersNested(NamedCluster item) {
            this.builder = new NamedClusterBuilder(this, item);
        }

        public N endCluster() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ConfigFluent.this.addToClusters(this.builder.build());
        }
    }
}

