/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserFluent<T extends UserFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    User.ApiVersion apiVersion;
    String fullName;
    List<String> groups = new ArrayList<String>();
    List<String> identities = new ArrayList<String>();
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public User.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(User.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public String getFullName() {
        return this.fullName;
    }

    public T withFullName(String fullName) {
        this.fullName = fullName;
        return (T)this;
    }

    public T addToGroups(String ... items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (T)this;
    }

    public T removeFromGroups(String ... items) {
        for (String item : items) {
            this.groups.remove(item);
        }
        return (T)this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public T withGroups(List<String> groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (T)this;
    }

    public T withGroups(String ... groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (T)this;
    }

    public T addToIdentities(String ... items) {
        for (String item : items) {
            this.identities.add(item);
        }
        return (T)this;
    }

    public T removeFromIdentities(String ... items) {
        for (String item : items) {
            this.identities.remove(item);
        }
        return (T)this;
    }

    public List<String> getIdentities() {
        return this.identities;
    }

    public T withIdentities(List<String> identities) {
        this.identities.clear();
        if (identities != null) {
            for (String item : identities) {
                this.addToIdentities(item);
            }
        }
        return (T)this;
    }

    public T withIdentities(String ... identities) {
        this.identities.clear();
        if (identities != null) {
            for (String item : identities) {
                this.addToIdentities(item);
            }
        }
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFluent that = (UserFluent)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.fullName != null ? !this.fullName.equals(that.fullName) : that.fullName != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.identities != null ? !this.identities.equals(that.identities) : that.identities != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)UserFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

