/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecBuilder;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildConfigStatus;
import io.fabric8.openshift.api.model.BuildConfigStatusBuilder;
import io.fabric8.openshift.api.model.BuildConfigStatusFluent;
import java.util.HashMap;
import java.util.Map;

public class BuildConfigFluent<T extends BuildConfigFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    BuildConfig.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<BuildConfigSpec, ?> spec;
    VisitableBuilder<BuildConfigStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildConfig.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(BuildConfig.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public BuildConfigSpec getSpec() {
        return this.spec != null ? (BuildConfigSpec)this.spec.build() : null;
    }

    public T withSpec(BuildConfigSpec spec) {
        if (spec != null) {
            this.spec = new BuildConfigSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    public SpecNested<T> withNewSpec() {
        return new SpecNested();
    }

    public SpecNested<T> withNewSpecLike(BuildConfigSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    public BuildConfigStatus getStatus() {
        return this.status != null ? (BuildConfigStatus)this.status.build() : null;
    }

    public T withStatus(BuildConfigStatus status) {
        if (status != null) {
            this.status = new BuildConfigStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    public StatusNested<T> withNewStatus() {
        return new StatusNested();
    }

    public StatusNested<T> withNewStatusLike(BuildConfigStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    public T withNewStatus(Integer lastVersion) {
        return this.withStatus(new BuildConfigStatus(lastVersion));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildConfigFluent that = (BuildConfigFluent)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StatusNested<N>
    extends BuildConfigStatusFluent<StatusNested<N>>
    implements Nested<N> {
        private final BuildConfigStatusBuilder builder;

        StatusNested(BuildConfigStatus item) {
            this.builder = new BuildConfigStatusBuilder(this, item);
        }

        StatusNested() {
            this.builder = new BuildConfigStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNested<N>
    extends BuildConfigSpecFluent<SpecNested<N>>
    implements Nested<N> {
        private final BuildConfigSpecBuilder builder;

        SpecNested() {
            this.builder = new BuildConfigSpecBuilder(this);
        }

        SpecNested(BuildConfigSpec item) {
            this.builder = new BuildConfigSpecBuilder(this, item);
        }

        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigFluent.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildConfigFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

