/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RBDVolumeSourceFluent<T extends RBDVolumeSourceFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    String fsType;
    String image;
    String keyring;
    List<String> monitors = new ArrayList<String>();
    String pool;
    Boolean readOnly;
    VisitableBuilder<LocalObjectReference, ?> secretRef;
    String user;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public String getFsType() {
        return this.fsType;
    }

    public T withFsType(String fsType) {
        this.fsType = fsType;
        return (T)this;
    }

    public String getImage() {
        return this.image;
    }

    public T withImage(String image) {
        this.image = image;
        return (T)this;
    }

    public String getKeyring() {
        return this.keyring;
    }

    public T withKeyring(String keyring) {
        this.keyring = keyring;
        return (T)this;
    }

    public T addToMonitors(String ... items) {
        for (String item : items) {
            this.monitors.add(item);
        }
        return (T)this;
    }

    public T removeFromMonitors(String ... items) {
        for (String item : items) {
            this.monitors.remove(item);
        }
        return (T)this;
    }

    public List<String> getMonitors() {
        return this.monitors;
    }

    public T withMonitors(List<String> monitors) {
        this.monitors.clear();
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (T)this;
    }

    public T withMonitors(String ... monitors) {
        this.monitors.clear();
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (T)this;
    }

    public String getPool() {
        return this.pool;
    }

    public T withPool(String pool) {
        this.pool = pool;
        return (T)this;
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public T withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (T)this;
    }

    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? (LocalObjectReference)this.secretRef.build() : null;
    }

    public T withSecretRef(LocalObjectReference secretRef) {
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.add(this.secretRef);
        }
        return (T)this;
    }

    public SecretRefNested<T> withNewSecretRef() {
        return new SecretRefNested();
    }

    public SecretRefNested<T> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<T> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    public T withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    public String getUser() {
        return this.user;
    }

    public T withUser(String user) {
        this.user = user;
        return (T)this;
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RBDVolumeSourceFluent that = (RBDVolumeSourceFluent)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.keyring != null ? !this.keyring.equals(that.keyring) : that.keyring != null) {
            return false;
        }
        if (this.monitors != null ? !this.monitors.equals(that.monitors) : that.monitors != null) {
            return false;
        }
        if (this.pool != null ? !this.pool.equals(that.pool) : that.pool != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SecretRefNested<N>
    extends LocalObjectReferenceFluent<SecretRefNested<N>>
    implements Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNested() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        public N endSecretRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)RBDVolumeSourceFluent.this.withSecretRef(this.builder.build());
        }
    }
}

