/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;
import io.fabric8.openshift.api.model.DeploymentConfigStatusFluent;
import io.fabric8.openshift.api.model.EditableDeploymentConfigStatus;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeploymentConfigStatusBuilder
extends DeploymentConfigStatusFluent<DeploymentConfigStatusBuilder>
implements VisitableBuilder<DeploymentConfigStatus, DeploymentConfigStatusBuilder> {
    DeploymentConfigStatusFluent<?> fluent;

    public DeploymentConfigStatusBuilder() {
        this(new DeploymentConfigStatus());
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent) {
        this(fluent, new DeploymentConfigStatus());
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent, DeploymentConfigStatus instance) {
        this.fluent = fluent;
        fluent.withDetails(instance.getDetails());
        fluent.withLatestVersion(instance.getLatestVersion());
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatus instance) {
        this.fluent = this;
        this.withDetails(instance.getDetails());
        this.withLatestVersion(instance.getLatestVersion());
    }

    @Override
    public EditableDeploymentConfigStatus build() {
        EditableDeploymentConfigStatus buildable = new EditableDeploymentConfigStatus(this.fluent.getDetails(), this.fluent.getLatestVersion());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigStatusBuilder that = (DeploymentConfigStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

