/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.api.model.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.SourceRevisionFluent;
import java.util.HashMap;
import java.util.Map;

public class BuildRequestFluent<T extends BuildRequestFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    BuildRequest.ApiVersion apiVersion;
    VisitableBuilder<ObjectReference, ?> from;
    String kind;
    Integer lastVersion;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<SourceRevision, ?> revision;
    VisitableBuilder<ObjectReference, ?> triggeredByImage;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildRequest.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(BuildRequest.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public ObjectReference getFrom() {
        return this.from != null ? (ObjectReference)this.from.build() : null;
    }

    public T withFrom(ObjectReference from) {
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.add(this.from);
        }
        return (T)this;
    }

    public FromNested<T> withNewFrom() {
        return new FromNested();
    }

    public FromNested<T> withNewFromLike(ObjectReference item) {
        return new FromNested(item);
    }

    public FromNested<T> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public Integer getLastVersion() {
        return this.lastVersion;
    }

    public T withLastVersion(Integer lastVersion) {
        this.lastVersion = lastVersion;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public SourceRevision getRevision() {
        return this.revision != null ? (SourceRevision)this.revision.build() : null;
    }

    public T withRevision(SourceRevision revision) {
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.add(this.revision);
        }
        return (T)this;
    }

    public RevisionNested<T> withNewRevision() {
        return new RevisionNested();
    }

    public RevisionNested<T> withNewRevisionLike(SourceRevision item) {
        return new RevisionNested(item);
    }

    public RevisionNested<T> editRevision() {
        return this.withNewRevisionLike(this.getRevision());
    }

    public ObjectReference getTriggeredByImage() {
        return this.triggeredByImage != null ? (ObjectReference)this.triggeredByImage.build() : null;
    }

    public T withTriggeredByImage(ObjectReference triggeredByImage) {
        if (triggeredByImage != null) {
            this.triggeredByImage = new ObjectReferenceBuilder(triggeredByImage);
            this._visitables.add(this.triggeredByImage);
        }
        return (T)this;
    }

    public TriggeredByImageNested<T> withNewTriggeredByImage() {
        return new TriggeredByImageNested();
    }

    public TriggeredByImageNested<T> withNewTriggeredByImageLike(ObjectReference item) {
        return new TriggeredByImageNested(item);
    }

    public TriggeredByImageNested<T> editTriggeredByImage() {
        return this.withNewTriggeredByImageLike(this.getTriggeredByImage());
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildRequestFluent that = (BuildRequestFluent)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastVersion != null ? !this.lastVersion.equals(that.lastVersion) : that.lastVersion != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.triggeredByImage != null ? !this.triggeredByImage.equals(that.triggeredByImage) : that.triggeredByImage != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class TriggeredByImageNested<N>
    extends ObjectReferenceFluent<TriggeredByImageNested<N>>
    implements Nested<N> {
        private final ObjectReferenceBuilder builder;

        TriggeredByImageNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        TriggeredByImageNested() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluent.this.withTriggeredByImage(this.builder.build());
        }

        public N endTriggeredByImage() {
            return this.and();
        }
    }

    public class RevisionNested<N>
    extends SourceRevisionFluent<RevisionNested<N>>
    implements Nested<N> {
        private final SourceRevisionBuilder builder;

        RevisionNested() {
            this.builder = new SourceRevisionBuilder(this);
        }

        RevisionNested(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        public N endRevision() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildRequestFluent.this.withRevision(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class FromNested<N>
    extends ObjectReferenceFluent<FromNested<N>>
    implements Nested<N> {
        private final ObjectReferenceBuilder builder;

        FromNested() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        FromNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N endFrom() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildRequestFluent.this.withFrom(this.builder.build());
        }
    }
}

