/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptions;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"allowHostDirVolumePlugin", "allowHostNetwork", "allowHostPorts", "allowPrivilegedContainer", "allowedCapabilities", "apiVersion", "groups", "kind", "metadata", "runAsUser", "seLinuxContext", "users"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class SecurityContextConstraints
implements HasMetadata {
    @JsonProperty(value="allowHostDirVolumePlugin")
    private Boolean allowHostDirVolumePlugin;
    @JsonProperty(value="allowHostNetwork")
    private Boolean allowHostNetwork;
    @JsonProperty(value="allowHostPorts")
    private Boolean allowHostPorts;
    @JsonProperty(value="allowPrivilegedContainer")
    private Boolean allowPrivilegedContainer;
    @JsonProperty(value="allowedCapabilities")
    @Valid
    private List<String> allowedCapabilities = new ArrayList<String>();
    @JsonProperty(value="apiVersion")
    @NotNull
    private ApiVersion apiVersion = ApiVersion.fromValue("v1");
    @JsonProperty(value="groups")
    @Valid
    private List<String> groups = new ArrayList<String>();
    @JsonProperty(value="kind")
    @NotNull
    private String kind = "SecurityContextConstraints";
    @JsonProperty(value="metadata")
    @Valid
    private ObjectMeta metadata;
    @JsonProperty(value="runAsUser")
    @Valid
    private RunAsUserStrategyOptions runAsUser;
    @JsonProperty(value="seLinuxContext")
    @Valid
    private SELinuxContextStrategyOptions seLinuxContext;
    @JsonProperty(value="users")
    @Valid
    private List<String> users = new ArrayList<String>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public SecurityContextConstraints() {
    }

    public SecurityContextConstraints(Boolean allowHostDirVolumePlugin, Boolean allowHostNetwork, Boolean allowHostPorts, Boolean allowPrivilegedContainer, List<String> allowedCapabilities, ApiVersion apiVersion, List<String> groups, String kind, ObjectMeta metadata, RunAsUserStrategyOptions runAsUser, SELinuxContextStrategyOptions seLinuxContext, List<String> users) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
        this.allowHostNetwork = allowHostNetwork;
        this.allowHostPorts = allowHostPorts;
        this.allowPrivilegedContainer = allowPrivilegedContainer;
        this.allowedCapabilities = allowedCapabilities;
        this.apiVersion = apiVersion;
        this.groups = groups;
        this.kind = kind;
        this.metadata = metadata;
        this.runAsUser = runAsUser;
        this.seLinuxContext = seLinuxContext;
        this.users = users;
    }

    @JsonProperty(value="allowHostDirVolumePlugin")
    public Boolean getAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin;
    }

    @JsonProperty(value="allowHostDirVolumePlugin")
    public void setAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
    }

    @JsonProperty(value="allowHostNetwork")
    public Boolean getAllowHostNetwork() {
        return this.allowHostNetwork;
    }

    @JsonProperty(value="allowHostNetwork")
    public void setAllowHostNetwork(Boolean allowHostNetwork) {
        this.allowHostNetwork = allowHostNetwork;
    }

    @JsonProperty(value="allowHostPorts")
    public Boolean getAllowHostPorts() {
        return this.allowHostPorts;
    }

    @JsonProperty(value="allowHostPorts")
    public void setAllowHostPorts(Boolean allowHostPorts) {
        this.allowHostPorts = allowHostPorts;
    }

    @JsonProperty(value="allowPrivilegedContainer")
    public Boolean getAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer;
    }

    @JsonProperty(value="allowPrivilegedContainer")
    public void setAllowPrivilegedContainer(Boolean allowPrivilegedContainer) {
        this.allowPrivilegedContainer = allowPrivilegedContainer;
    }

    @JsonProperty(value="allowedCapabilities")
    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    @JsonProperty(value="allowedCapabilities")
    public void setAllowedCapabilities(List<String> allowedCapabilities) {
        this.allowedCapabilities = allowedCapabilities;
    }

    @JsonProperty(value="apiVersion")
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="groups")
    public List<String> getGroups() {
        return this.groups;
    }

    @JsonProperty(value="groups")
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="runAsUser")
    public RunAsUserStrategyOptions getRunAsUser() {
        return this.runAsUser;
    }

    @JsonProperty(value="runAsUser")
    public void setRunAsUser(RunAsUserStrategyOptions runAsUser) {
        this.runAsUser = runAsUser;
    }

    @JsonProperty(value="seLinuxContext")
    public SELinuxContextStrategyOptions getSeLinuxContext() {
        return this.seLinuxContext;
    }

    @JsonProperty(value="seLinuxContext")
    public void setSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
        this.seLinuxContext = seLinuxContext;
    }

    @JsonProperty(value="users")
    public List<String> getUsers() {
        return this.users;
    }

    @JsonProperty(value="users")
    public void setUsers(List<String> users) {
        this.users = users;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "SecurityContextConstraints(allowHostDirVolumePlugin=" + this.getAllowHostDirVolumePlugin() + ", allowHostNetwork=" + this.getAllowHostNetwork() + ", allowHostPorts=" + this.getAllowHostPorts() + ", allowPrivilegedContainer=" + this.getAllowPrivilegedContainer() + ", allowedCapabilities=" + this.getAllowedCapabilities() + ", apiVersion=" + (Object)((Object)this.getApiVersion()) + ", groups=" + this.getGroups() + ", kind=" + this.getKind() + ", metadata=" + this.getMetadata() + ", runAsUser=" + this.getRunAsUser() + ", seLinuxContext=" + this.getSeLinuxContext() + ", users=" + this.getUsers() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityContextConstraints)) {
            return false;
        }
        SecurityContextConstraints other = (SecurityContextConstraints)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$allowHostDirVolumePlugin = this.getAllowHostDirVolumePlugin();
        Boolean other$allowHostDirVolumePlugin = other.getAllowHostDirVolumePlugin();
        if (this$allowHostDirVolumePlugin == null ? other$allowHostDirVolumePlugin != null : !((Object)this$allowHostDirVolumePlugin).equals(other$allowHostDirVolumePlugin)) {
            return false;
        }
        Boolean this$allowHostNetwork = this.getAllowHostNetwork();
        Boolean other$allowHostNetwork = other.getAllowHostNetwork();
        if (this$allowHostNetwork == null ? other$allowHostNetwork != null : !((Object)this$allowHostNetwork).equals(other$allowHostNetwork)) {
            return false;
        }
        Boolean this$allowHostPorts = this.getAllowHostPorts();
        Boolean other$allowHostPorts = other.getAllowHostPorts();
        if (this$allowHostPorts == null ? other$allowHostPorts != null : !((Object)this$allowHostPorts).equals(other$allowHostPorts)) {
            return false;
        }
        Boolean this$allowPrivilegedContainer = this.getAllowPrivilegedContainer();
        Boolean other$allowPrivilegedContainer = other.getAllowPrivilegedContainer();
        if (this$allowPrivilegedContainer == null ? other$allowPrivilegedContainer != null : !((Object)this$allowPrivilegedContainer).equals(other$allowPrivilegedContainer)) {
            return false;
        }
        List<String> this$allowedCapabilities = this.getAllowedCapabilities();
        List<String> other$allowedCapabilities = other.getAllowedCapabilities();
        if (this$allowedCapabilities == null ? other$allowedCapabilities != null : !((Object)this$allowedCapabilities).equals(other$allowedCapabilities)) {
            return false;
        }
        ApiVersion this$apiVersion = this.getApiVersion();
        ApiVersion other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !((Object)((Object)this$apiVersion)).equals((Object)other$apiVersion)) {
            return false;
        }
        List<String> this$groups = this.getGroups();
        List<String> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        RunAsUserStrategyOptions this$runAsUser = this.getRunAsUser();
        RunAsUserStrategyOptions other$runAsUser = other.getRunAsUser();
        if (this$runAsUser == null ? other$runAsUser != null : !((Object)this$runAsUser).equals(other$runAsUser)) {
            return false;
        }
        SELinuxContextStrategyOptions this$seLinuxContext = this.getSeLinuxContext();
        SELinuxContextStrategyOptions other$seLinuxContext = other.getSeLinuxContext();
        if (this$seLinuxContext == null ? other$seLinuxContext != null : !((Object)this$seLinuxContext).equals(other$seLinuxContext)) {
            return false;
        }
        List<String> this$users = this.getUsers();
        List<String> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityContextConstraints;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowHostDirVolumePlugin = this.getAllowHostDirVolumePlugin();
        result = result * 59 + ($allowHostDirVolumePlugin == null ? 0 : ((Object)$allowHostDirVolumePlugin).hashCode());
        Boolean $allowHostNetwork = this.getAllowHostNetwork();
        result = result * 59 + ($allowHostNetwork == null ? 0 : ((Object)$allowHostNetwork).hashCode());
        Boolean $allowHostPorts = this.getAllowHostPorts();
        result = result * 59 + ($allowHostPorts == null ? 0 : ((Object)$allowHostPorts).hashCode());
        Boolean $allowPrivilegedContainer = this.getAllowPrivilegedContainer();
        result = result * 59 + ($allowPrivilegedContainer == null ? 0 : ((Object)$allowPrivilegedContainer).hashCode());
        List<String> $allowedCapabilities = this.getAllowedCapabilities();
        result = result * 59 + ($allowedCapabilities == null ? 0 : ((Object)$allowedCapabilities).hashCode());
        ApiVersion $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 0 : ((Object)((Object)$apiVersion)).hashCode());
        List<String> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 0 : ((Object)$groups).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 0 : $kind.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 0 : ((Object)$metadata).hashCode());
        RunAsUserStrategyOptions $runAsUser = this.getRunAsUser();
        result = result * 59 + ($runAsUser == null ? 0 : ((Object)$runAsUser).hashCode());
        SELinuxContextStrategyOptions $seLinuxContext = this.getSeLinuxContext();
        result = result * 59 + ($seLinuxContext == null ? 0 : ((Object)$seLinuxContext).hashCode());
        List<String> $users = this.getUsers();
        result = result * 59 + ($users == null ? 0 : ((Object)$users).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 0 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public static enum ApiVersion {
        V_1("v1");

        private final String value;
        private static Map<String, ApiVersion> constants;

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ApiVersion fromValue(String value) {
            ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, ApiVersion>();
            for (ApiVersion c : ApiVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

