/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableEvent;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EventBuilder
extends EventFluent<EventBuilder>
implements VisitableBuilder<Event, EventBuilder> {
    EventFluent<?> fluent;

    public EventBuilder() {
        this(new Event());
    }

    public EventBuilder(EventFluent<?> fluent) {
        this(fluent, new Event());
    }

    public EventBuilder(EventFluent<?> fluent, Event instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withCount(instance.getCount());
        fluent.withFirstTimestamp(instance.getFirstTimestamp());
        fluent.withInvolvedObject(instance.getInvolvedObject());
        fluent.withKind(instance.getKind());
        fluent.withLastTimestamp(instance.getLastTimestamp());
        fluent.withMessage(instance.getMessage());
        fluent.withMetadata(instance.getMetadata());
        fluent.withReason(instance.getReason());
        fluent.withSource(instance.getSource());
    }

    public EventBuilder(Event instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withCount(instance.getCount());
        this.withFirstTimestamp(instance.getFirstTimestamp());
        this.withInvolvedObject(instance.getInvolvedObject());
        this.withKind(instance.getKind());
        this.withLastTimestamp(instance.getLastTimestamp());
        this.withMessage(instance.getMessage());
        this.withMetadata(instance.getMetadata());
        this.withReason(instance.getReason());
        this.withSource(instance.getSource());
    }

    @Override
    public EditableEvent build() {
        EditableEvent buildable = new EditableEvent(this.fluent.getApiVersion(), this.fluent.getCount(), this.fluent.getFirstTimestamp(), this.fluent.getInvolvedObject(), this.fluent.getKind(), this.fluent.getLastTimestamp(), this.fluent.getMessage(), this.fluent.getMetadata(), this.fluent.getReason(), this.fluent.getSource());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventBuilder that = (EventBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

