/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableVolume;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class VolumeBuilder
extends VolumeFluent<VolumeBuilder>
implements VisitableBuilder<Volume, VolumeBuilder> {
    VolumeFluent<?> fluent;

    public VolumeBuilder() {
        this(new Volume());
    }

    public VolumeBuilder(VolumeFluent<?> fluent) {
        this(fluent, new Volume());
    }

    public VolumeBuilder(VolumeFluent<?> fluent, Volume instance) {
        this.fluent = fluent;
        fluent.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        fluent.withCephfs(instance.getCephfs());
        fluent.withEmptyDir(instance.getEmptyDir());
        fluent.withGcePersistentDisk(instance.getGcePersistentDisk());
        fluent.withGitRepo(instance.getGitRepo());
        fluent.withGlusterfs(instance.getGlusterfs());
        fluent.withHostPath(instance.getHostPath());
        fluent.withIscsi(instance.getIscsi());
        fluent.withMetadata(instance.getMetadata());
        fluent.withName(instance.getName());
        fluent.withNfs(instance.getNfs());
        fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        fluent.withRbd(instance.getRbd());
        fluent.withSecret(instance.getSecret());
    }

    public VolumeBuilder(Volume instance) {
        this.fluent = this;
        this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        this.withCephfs(instance.getCephfs());
        this.withEmptyDir(instance.getEmptyDir());
        this.withGcePersistentDisk(instance.getGcePersistentDisk());
        this.withGitRepo(instance.getGitRepo());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostPath(instance.getHostPath());
        this.withIscsi(instance.getIscsi());
        this.withMetadata(instance.getMetadata());
        this.withName(instance.getName());
        this.withNfs(instance.getNfs());
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        this.withRbd(instance.getRbd());
        this.withSecret(instance.getSecret());
    }

    @Override
    public EditableVolume build() {
        EditableVolume buildable = new EditableVolume(this.fluent.getAwsElasticBlockStore(), this.fluent.getCephfs(), this.fluent.getEmptyDir(), this.fluent.getGcePersistentDisk(), this.fluent.getGitRepo(), this.fluent.getGlusterfs(), this.fluent.getHostPath(), this.fluent.getIscsi(), this.fluent.getMetadata(), this.fluent.getName(), this.fluent.getNfs(), this.fluent.getPersistentVolumeClaim(), this.fluent.getRbd(), this.fluent.getSecret());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeBuilder that = (VolumeBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

