/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableSecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SecurityContextConstraintsBuilder
extends SecurityContextConstraintsFluent<SecurityContextConstraintsBuilder>
implements VisitableBuilder<SecurityContextConstraints, SecurityContextConstraintsBuilder> {
    SecurityContextConstraintsFluent<?> fluent;

    public SecurityContextConstraintsBuilder() {
        this(new SecurityContextConstraints());
    }

    public SecurityContextConstraintsBuilder(SecurityContextConstraintsFluent<?> fluent) {
        this(fluent, new SecurityContextConstraints());
    }

    public SecurityContextConstraintsBuilder(SecurityContextConstraintsFluent<?> fluent, SecurityContextConstraints instance) {
        this.fluent = fluent;
        fluent.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin());
        fluent.withAllowHostNetwork(instance.getAllowHostNetwork());
        fluent.withAllowHostPorts(instance.getAllowHostPorts());
        fluent.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer());
        fluent.withAllowedCapabilities(instance.getAllowedCapabilities());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withGroups(instance.getGroups());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinuxContext(instance.getSeLinuxContext());
        fluent.withUsers(instance.getUsers());
    }

    public SecurityContextConstraintsBuilder(SecurityContextConstraints instance) {
        this.fluent = this;
        this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin());
        this.withAllowHostNetwork(instance.getAllowHostNetwork());
        this.withAllowHostPorts(instance.getAllowHostPorts());
        this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer());
        this.withAllowedCapabilities(instance.getAllowedCapabilities());
        this.withApiVersion(instance.getApiVersion());
        this.withGroups(instance.getGroups());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxContext(instance.getSeLinuxContext());
        this.withUsers(instance.getUsers());
    }

    @Override
    public EditableSecurityContextConstraints build() {
        EditableSecurityContextConstraints buildable = new EditableSecurityContextConstraints(this.fluent.isAllowHostDirVolumePlugin(), this.fluent.isAllowHostNetwork(), this.fluent.isAllowHostPorts(), this.fluent.isAllowPrivilegedContainer(), this.fluent.getAllowedCapabilities(), this.fluent.getApiVersion(), this.fluent.getGroups(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRunAsUser(), this.fluent.getSeLinuxContext(), this.fluent.getUsers());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecurityContextConstraintsBuilder that = (SecurityContextConstraintsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

