/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"annotations", "creationTimestamp", "deletionTimestamp", "generateName", "generation", "labels", "name", "namespace", "resourceVersion", "selfLink", "uid"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class ObjectMeta {
    @JsonProperty(value="annotations")
    @Valid
    private Map<String, String> annotations;
    @JsonProperty(value="creationTimestamp")
    private String creationTimestamp;
    @JsonProperty(value="deletionTimestamp")
    private String deletionTimestamp;
    @JsonProperty(value="generateName")
    private String generateName;
    @JsonProperty(value="generation")
    private Long generation;
    @JsonProperty(value="labels")
    @Valid
    private Map<String, String> labels;
    @JsonProperty(value="name")
    @Pattern(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?$")
    @Size(max=63)
    private String name;
    @JsonProperty(value="namespace")
    @Pattern(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$")
    @Size(max=253)
    private String namespace;
    @JsonProperty(value="resourceVersion")
    private String resourceVersion;
    @JsonProperty(value="selfLink")
    private String selfLink;
    @JsonProperty(value="uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ObjectMeta() {
    }

    public ObjectMeta(Map<String, String> annotations, String creationTimestamp, String deletionTimestamp, String generateName, Long generation, Map<String, String> labels, String name, String namespace, String resourceVersion, String selfLink, String uid) {
        this.annotations = annotations;
        this.creationTimestamp = creationTimestamp;
        this.deletionTimestamp = deletionTimestamp;
        this.generateName = generateName;
        this.generation = generation;
        this.labels = labels;
        this.name = name;
        this.namespace = namespace;
        this.resourceVersion = resourceVersion;
        this.selfLink = selfLink;
        this.uid = uid;
    }

    @JsonProperty(value="annotations")
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @JsonProperty(value="annotations")
    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    @JsonProperty(value="creationTimestamp")
    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @JsonProperty(value="creationTimestamp")
    public void setCreationTimestamp(String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    @JsonProperty(value="deletionTimestamp")
    public String getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    @JsonProperty(value="deletionTimestamp")
    public void setDeletionTimestamp(String deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
    }

    @JsonProperty(value="generateName")
    public String getGenerateName() {
        return this.generateName;
    }

    @JsonProperty(value="generateName")
    public void setGenerateName(String generateName) {
        this.generateName = generateName;
    }

    @JsonProperty(value="generation")
    public Long getGeneration() {
        return this.generation;
    }

    @JsonProperty(value="generation")
    public void setGeneration(Long generation) {
        this.generation = generation;
    }

    @JsonProperty(value="labels")
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="resourceVersion")
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    @JsonProperty(value="resourceVersion")
    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    @JsonProperty(value="selfLink")
    public String getSelfLink() {
        return this.selfLink;
    }

    @JsonProperty(value="selfLink")
    public void setSelfLink(String selfLink) {
        this.selfLink = selfLink;
    }

    @JsonProperty(value="uid")
    public String getUid() {
        return this.uid;
    }

    @JsonProperty(value="uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.annotations).append((Object)this.creationTimestamp).append((Object)this.deletionTimestamp).append((Object)this.generateName).append((Object)this.generation).append(this.labels).append((Object)this.name).append((Object)this.namespace).append((Object)this.resourceVersion).append((Object)this.selfLink).append((Object)this.uid).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ObjectMeta)) {
            return false;
        }
        ObjectMeta rhs = (ObjectMeta)other;
        return new EqualsBuilder().append(this.annotations, rhs.annotations).append((Object)this.creationTimestamp, (Object)rhs.creationTimestamp).append((Object)this.deletionTimestamp, (Object)rhs.deletionTimestamp).append((Object)this.generateName, (Object)rhs.generateName).append((Object)this.generation, (Object)rhs.generation).append(this.labels, rhs.labels).append((Object)this.name, (Object)rhs.name).append((Object)this.namespace, (Object)rhs.namespace).append((Object)this.resourceVersion, (Object)rhs.resourceVersion).append((Object)this.selfLink, (Object)rhs.selfLink).append((Object)this.uid, (Object)rhs.uid).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }
}

