/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@JsonPropertyOrder(value={"IntVal", "Kind", "StrVal"})
public class IntOrString {
    @JsonProperty(value="IntVal")
    private Integer IntVal;
    @JsonProperty(value="Kind")
    private Integer Kind;
    @JsonProperty(value="StrVal")
    private String StrVal;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public IntOrString() {
    }

    public IntOrString(Integer intVal, Integer kind, String strVal, Map<String, Object> additionalProperties) {
        this.IntVal = intVal;
        this.Kind = kind;
        this.StrVal = strVal;
        this.additionalProperties = additionalProperties;
    }

    public IntOrString(Integer intVal) {
        this(intVal, 0, null, new HashMap<String, Object>());
    }

    public IntOrString(String strVal) {
        this(null, 1, strVal, new HashMap<String, Object>());
    }

    @JsonProperty(value="IntVal")
    public Integer getIntVal() {
        return this.IntVal;
    }

    @JsonProperty(value="IntVal")
    public void setIntVal(Integer IntVal) {
        this.IntVal = IntVal;
    }

    @JsonProperty(value="Kind")
    public Integer getKind() {
        return this.Kind;
    }

    @JsonProperty(value="Kind")
    public void setKind(Integer Kind) {
        this.Kind = Kind;
    }

    @JsonProperty(value="StrVal")
    public String getStrVal() {
        return this.StrVal;
    }

    @JsonProperty(value="StrVal")
    public void setStrVal(String StrVal) {
        this.StrVal = StrVal;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public static class Deserializer
    extends JsonDeserializer<IntOrString> {
        public IntOrString deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            IntOrString intOrString = new IntOrString();
            int asInt = node.asInt();
            if (asInt != 0) {
                intOrString.setIntVal(asInt);
            } else {
                intOrString.setStrVal(node.asText());
            }
            return intOrString;
        }
    }

    public static class Serializer
    extends JsonSerializer<IntOrString> {
        public void serialize(IntOrString value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null) {
                Integer intValue = value.getIntVal();
                if (intValue != null) {
                    jgen.writeNumber(intValue.intValue());
                } else {
                    String stringValue = value.getStrVal();
                    if (stringValue != null) {
                        jgen.writeString(stringValue);
                    } else {
                        jgen.writeNull();
                    }
                }
            } else {
                jgen.writeNull();
            }
        }
    }
}

