/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateRunningBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateRunningFluent;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluent;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateWaitingFluent;
import java.util.HashMap;
import java.util.Map;

public class ContainerStateFluent<T extends ContainerStateFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    VisitableBuilder<ContainerStateRunning, ?> running;
    VisitableBuilder<ContainerStateTerminated, ?> terminated;
    VisitableBuilder<ContainerStateWaiting, ?> waiting;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ContainerStateRunning getRunning() {
        return this.running != null ? (ContainerStateRunning)this.running.build() : null;
    }

    public T withRunning(ContainerStateRunning running) {
        if (running != null) {
            this.running = new ContainerStateRunningBuilder(running);
            this._visitables.add(this.running);
        }
        return (T)this;
    }

    public RunningNested<T> withNewRunning() {
        return new RunningNested();
    }

    public RunningNested<T> withNewRunningLike(ContainerStateRunning item) {
        return new RunningNested(item);
    }

    public RunningNested<T> editRunning() {
        return this.withNewRunningLike(this.getRunning());
    }

    public T withNewRunning(String startedAt) {
        return this.withRunning(new ContainerStateRunning(startedAt));
    }

    public ContainerStateTerminated getTerminated() {
        return this.terminated != null ? (ContainerStateTerminated)this.terminated.build() : null;
    }

    public T withTerminated(ContainerStateTerminated terminated) {
        if (terminated != null) {
            this.terminated = new ContainerStateTerminatedBuilder(terminated);
            this._visitables.add(this.terminated);
        }
        return (T)this;
    }

    public TerminatedNested<T> withNewTerminated() {
        return new TerminatedNested();
    }

    public TerminatedNested<T> withNewTerminatedLike(ContainerStateTerminated item) {
        return new TerminatedNested(item);
    }

    public TerminatedNested<T> editTerminated() {
        return this.withNewTerminatedLike(this.getTerminated());
    }

    public ContainerStateWaiting getWaiting() {
        return this.waiting != null ? (ContainerStateWaiting)this.waiting.build() : null;
    }

    public T withWaiting(ContainerStateWaiting waiting) {
        if (waiting != null) {
            this.waiting = new ContainerStateWaitingBuilder(waiting);
            this._visitables.add(this.waiting);
        }
        return (T)this;
    }

    public WaitingNested<T> withNewWaiting() {
        return new WaitingNested();
    }

    public WaitingNested<T> withNewWaitingLike(ContainerStateWaiting item) {
        return new WaitingNested(item);
    }

    public WaitingNested<T> editWaiting() {
        return this.withNewWaitingLike(this.getWaiting());
    }

    public T withNewWaiting(String reason) {
        return this.withWaiting(new ContainerStateWaiting(reason));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class WaitingNested<N>
    extends ContainerStateWaitingFluent<WaitingNested<N>>
    implements Nested<N> {
        private final ContainerStateWaitingBuilder builder;

        WaitingNested() {
            this.builder = new ContainerStateWaitingBuilder(this);
        }

        WaitingNested(ContainerStateWaiting item) {
            this.builder = new ContainerStateWaitingBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerStateFluent.this.withWaiting(this.builder.build());
        }

        public N endWaiting() {
            return this.and();
        }
    }

    public class TerminatedNested<N>
    extends ContainerStateTerminatedFluent<TerminatedNested<N>>
    implements Nested<N> {
        private final ContainerStateTerminatedBuilder builder;

        TerminatedNested(ContainerStateTerminated item) {
            this.builder = new ContainerStateTerminatedBuilder(this, item);
        }

        TerminatedNested() {
            this.builder = new ContainerStateTerminatedBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerStateFluent.this.withTerminated(this.builder.build());
        }

        public N endTerminated() {
            return this.and();
        }
    }

    public class RunningNested<N>
    extends ContainerStateRunningFluent<RunningNested<N>>
    implements Nested<N> {
        private final ContainerStateRunningBuilder builder;

        RunningNested() {
            this.builder = new ContainerStateRunningBuilder(this);
        }

        RunningNested(ContainerStateRunning item) {
            this.builder = new ContainerStateRunningBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerStateFluent.this.withRunning(this.builder.build());
        }

        public N endRunning() {
            return this.and();
        }
    }
}

