/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.RBDVolumeSource;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistentVolumeSpecFluent<T extends PersistentVolumeSpecFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    List<String> accessModes = new ArrayList<String>();
    VisitableBuilder<AWSElasticBlockStoreVolumeSource, ?> awsElasticBlockStore;
    Map<String, Quantity> capacity = new HashMap<String, Quantity>();
    VisitableBuilder<ObjectReference, ?> claimRef;
    VisitableBuilder<GCEPersistentDiskVolumeSource, ?> gcePersistentDisk;
    VisitableBuilder<GlusterfsVolumeSource, ?> glusterfs;
    VisitableBuilder<HostPathVolumeSource, ?> hostPath;
    VisitableBuilder<NFSVolumeSource, ?> nfs;
    VisitableBuilder<RBDVolumeSource, ?> rbd;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public T addToAccessModes(String item) {
        if (item != null) {
            this.accessModes.add(item);
        }
        return (T)this;
    }

    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public T withAccessModes(List<String> accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (T)this;
    }

    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
        return this.awsElasticBlockStore != null ? (AWSElasticBlockStoreVolumeSource)this.awsElasticBlockStore.build() : null;
    }

    public T withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        if (awsElasticBlockStore != null) {
            this.awsElasticBlockStore = new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore);
            this._visitables.add(this.awsElasticBlockStore);
        }
        return (T)this;
    }

    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStore() {
        return new AwsElasticBlockStoreNested();
    }

    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
        return new AwsElasticBlockStoreNested(item);
    }

    public AwsElasticBlockStoreNested<T> editAwsElasticBlockStore() {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore());
    }

    public T withNewAwsElasticBlockStore(String fsType, Integer partition, Boolean readOnly, String volumeID) {
        return this.withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }

    public T addToCapacity(String key, Quantity value) {
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    public T withCapacity(Map<String, Quantity> capacity) {
        this.capacity.clear();
        if (capacity != null) {
            this.capacity.putAll(capacity);
        }
        return (T)this;
    }

    public ObjectReference getClaimRef() {
        return this.claimRef != null ? (ObjectReference)this.claimRef.build() : null;
    }

    public T withClaimRef(ObjectReference claimRef) {
        if (claimRef != null) {
            this.claimRef = new ObjectReferenceBuilder(claimRef);
            this._visitables.add(this.claimRef);
        }
        return (T)this;
    }

    public ClaimRefNested<T> withNewClaimRef() {
        return new ClaimRefNested();
    }

    public ClaimRefNested<T> withNewClaimRefLike(ObjectReference item) {
        return new ClaimRefNested(item);
    }

    public ClaimRefNested<T> editClaimRef() {
        return this.withNewClaimRefLike(this.getClaimRef());
    }

    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return this.gcePersistentDisk != null ? (GCEPersistentDiskVolumeSource)this.gcePersistentDisk.build() : null;
    }

    public T withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        if (gcePersistentDisk != null) {
            this.gcePersistentDisk = new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk);
            this._visitables.add(this.gcePersistentDisk);
        }
        return (T)this;
    }

    public GcePersistentDiskNested<T> withNewGcePersistentDisk() {
        return new GcePersistentDiskNested();
    }

    public GcePersistentDiskNested<T> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
        return new GcePersistentDiskNested(item);
    }

    public GcePersistentDiskNested<T> editGcePersistentDisk() {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk());
    }

    public T withNewGcePersistentDisk(String fsType, Integer partition, String pdName, Boolean readOnly) {
        return this.withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    public GlusterfsVolumeSource getGlusterfs() {
        return this.glusterfs != null ? (GlusterfsVolumeSource)this.glusterfs.build() : null;
    }

    public T withGlusterfs(GlusterfsVolumeSource glusterfs) {
        if (glusterfs != null) {
            this.glusterfs = new GlusterfsVolumeSourceBuilder(glusterfs);
            this._visitables.add(this.glusterfs);
        }
        return (T)this;
    }

    public GlusterfsNested<T> withNewGlusterfs() {
        return new GlusterfsNested();
    }

    public GlusterfsNested<T> withNewGlusterfsLike(GlusterfsVolumeSource item) {
        return new GlusterfsNested(item);
    }

    public GlusterfsNested<T> editGlusterfs() {
        return this.withNewGlusterfsLike(this.getGlusterfs());
    }

    public T withNewGlusterfs(String endpoints, String path, Boolean readOnly) {
        return this.withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    public HostPathVolumeSource getHostPath() {
        return this.hostPath != null ? (HostPathVolumeSource)this.hostPath.build() : null;
    }

    public T withHostPath(HostPathVolumeSource hostPath) {
        if (hostPath != null) {
            this.hostPath = new HostPathVolumeSourceBuilder(hostPath);
            this._visitables.add(this.hostPath);
        }
        return (T)this;
    }

    public HostPathNested<T> withNewHostPath() {
        return new HostPathNested();
    }

    public HostPathNested<T> withNewHostPathLike(HostPathVolumeSource item) {
        return new HostPathNested(item);
    }

    public HostPathNested<T> editHostPath() {
        return this.withNewHostPathLike(this.getHostPath());
    }

    public T withNewHostPath(String path) {
        return this.withHostPath(new HostPathVolumeSource(path));
    }

    public NFSVolumeSource getNfs() {
        return this.nfs != null ? (NFSVolumeSource)this.nfs.build() : null;
    }

    public T withNfs(NFSVolumeSource nfs) {
        if (nfs != null) {
            this.nfs = new NFSVolumeSourceBuilder(nfs);
            this._visitables.add(this.nfs);
        }
        return (T)this;
    }

    public NfsNested<T> withNewNfs() {
        return new NfsNested();
    }

    public NfsNested<T> withNewNfsLike(NFSVolumeSource item) {
        return new NfsNested(item);
    }

    public NfsNested<T> editNfs() {
        return this.withNewNfsLike(this.getNfs());
    }

    public T withNewNfs(String path, Boolean readOnly, String server) {
        return this.withNfs(new NFSVolumeSource(path, readOnly, server));
    }

    public RBDVolumeSource getRbd() {
        return this.rbd != null ? (RBDVolumeSource)this.rbd.build() : null;
    }

    public T withRbd(RBDVolumeSource rbd) {
        if (rbd != null) {
            this.rbd = new RBDVolumeSourceBuilder(rbd);
            this._visitables.add(this.rbd);
        }
        return (T)this;
    }

    public RbdNested<T> withNewRbd() {
        return new RbdNested();
    }

    public RbdNested<T> withNewRbdLike(RBDVolumeSource item) {
        return new RbdNested(item);
    }

    public RbdNested<T> editRbd() {
        return this.withNewRbdLike(this.getRbd());
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class RbdNested<N>
    extends RBDVolumeSourceFluent<RbdNested<N>>
    implements Nested<N> {
        private final RBDVolumeSourceBuilder builder;

        RbdNested() {
            this.builder = new RBDVolumeSourceBuilder(this);
        }

        RbdNested(RBDVolumeSource item) {
            this.builder = new RBDVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withRbd(this.builder.build());
        }

        public N endRbd() {
            return this.and();
        }
    }

    public class NfsNested<N>
    extends NFSVolumeSourceFluent<NfsNested<N>>
    implements Nested<N> {
        private final NFSVolumeSourceBuilder builder;

        NfsNested() {
            this.builder = new NFSVolumeSourceBuilder(this);
        }

        NfsNested(NFSVolumeSource item) {
            this.builder = new NFSVolumeSourceBuilder(this, item);
        }

        public N endNfs() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withNfs(this.builder.build());
        }
    }

    public class HostPathNested<N>
    extends HostPathVolumeSourceFluent<HostPathNested<N>>
    implements Nested<N> {
        private final HostPathVolumeSourceBuilder builder;

        HostPathNested(HostPathVolumeSource item) {
            this.builder = new HostPathVolumeSourceBuilder(this, item);
        }

        HostPathNested() {
            this.builder = new HostPathVolumeSourceBuilder(this);
        }

        public N endHostPath() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withHostPath(this.builder.build());
        }
    }

    public class GlusterfsNested<N>
    extends GlusterfsVolumeSourceFluent<GlusterfsNested<N>>
    implements Nested<N> {
        private final GlusterfsVolumeSourceBuilder builder;

        GlusterfsNested(GlusterfsVolumeSource item) {
            this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }

        GlusterfsNested() {
            this.builder = new GlusterfsVolumeSourceBuilder(this);
        }

        public N endGlusterfs() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withGlusterfs(this.builder.build());
        }
    }

    public class GcePersistentDiskNested<N>
    extends GCEPersistentDiskVolumeSourceFluent<GcePersistentDiskNested<N>>
    implements Nested<N> {
        private final GCEPersistentDiskVolumeSourceBuilder builder;

        GcePersistentDiskNested(GCEPersistentDiskVolumeSource item) {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }

        GcePersistentDiskNested() {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }

        public N endGcePersistentDisk() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withGcePersistentDisk(this.builder.build());
        }
    }

    public class ClaimRefNested<N>
    extends ObjectReferenceFluent<ClaimRefNested<N>>
    implements Nested<N> {
        private final ObjectReferenceBuilder builder;

        ClaimRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ClaimRefNested() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withClaimRef(this.builder.build());
        }

        public N endClaimRef() {
            return this.and();
        }
    }

    public class AwsElasticBlockStoreNested<N>
    extends AWSElasticBlockStoreVolumeSourceFluent<AwsElasticBlockStoreNested<N>>
    implements Nested<N> {
        private final AWSElasticBlockStoreVolumeSourceBuilder builder;

        AwsElasticBlockStoreNested(AWSElasticBlockStoreVolumeSource item) {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }

        AwsElasticBlockStoreNested() {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }

        public N endAwsElasticBlockStore() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withAwsElasticBlockStore(this.builder.build());
        }
    }
}

