/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.storage.v1beta1.VolumeAttributesClass;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class VolumeAttributesClassFluent<A extends VolumeAttributesClassFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private String driverName;
    private String kind;
    private ObjectMetaBuilder metadata;
    private Map<String, String> parameters;

    public VolumeAttributesClassFluent() {
    }

    public VolumeAttributesClassFluent(VolumeAttributesClass instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToParameters(Map<String, String> map) {
        if (this.parameters == null && map != null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.parameters.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToParameters(String key, String value) {
        if (this.parameters == null && key != null && value != null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.parameters.put(key, value);
        }
        return (A)((Object)this);
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    protected void copyInstance(VolumeAttributesClass instance) {
        VolumeAttributesClass volumeAttributesClass = instance = instance != null ? instance : new VolumeAttributesClass();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDriverName(instance.getDriverName());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withParameters(instance.getParameters());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeAttributesClassFluent that = (VolumeAttributesClassFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.parameters, that.parameters)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getKind() {
        return this.kind;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasDriverName() {
        return this.driverName != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean hasParameters() {
        return this.parameters != null;
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.driverName, this.kind, this.metadata, this.parameters, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromParameters(String key) {
        if (this.parameters == null) {
            return (A)((Object)this);
        }
        if (key != null && this.parameters != null) {
            this.parameters.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromParameters(Map<String, String> map) {
        if (this.parameters == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.parameters == null) continue;
                this.parameters.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("parameters:");
            sb.append(this.parameters);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public <K, V> A withParameters(Map<String, String> parameters) {
        this.parameters = parameters == null ? null : new LinkedHashMap<String, String>(parameters);
        return (A)((Object)this);
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)VolumeAttributesClassFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

