/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.storage;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.storage.CSIStorageCapacityBuilder;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "capacity", "maximumVolumeSize", "nodeTopology", "storageClassName"})
@Version(value="v1")
@Group(value="storage.k8s.io")
public class CSIStorageCapacity
implements Editable<CSIStorageCapacityBuilder>,
HasMetadata,
Namespaced {
    @JsonProperty(value="apiVersion")
    private String apiVersion = "storage.k8s.io/v1";
    @JsonProperty(value="capacity")
    private Quantity capacity;
    @JsonProperty(value="kind")
    private String kind = "CSIStorageCapacity";
    @JsonProperty(value="maximumVolumeSize")
    private Quantity maximumVolumeSize;
    @JsonProperty(value="metadata")
    private ObjectMeta metadata;
    @JsonProperty(value="nodeTopology")
    private LabelSelector nodeTopology;
    @JsonProperty(value="storageClassName")
    private String storageClassName;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public CSIStorageCapacity() {
    }

    public CSIStorageCapacity(String apiVersion, Quantity capacity, String kind, Quantity maximumVolumeSize, ObjectMeta metadata, LabelSelector nodeTopology, String storageClassName) {
        this.apiVersion = apiVersion;
        this.capacity = capacity;
        this.kind = kind;
        this.maximumVolumeSize = maximumVolumeSize;
        this.metadata = metadata;
        this.nodeTopology = nodeTopology;
        this.storageClassName = storageClassName;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="capacity")
    public Quantity getCapacity() {
        return this.capacity;
    }

    @JsonProperty(value="capacity")
    public void setCapacity(Quantity capacity) {
        this.capacity = capacity;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="maximumVolumeSize")
    public Quantity getMaximumVolumeSize() {
        return this.maximumVolumeSize;
    }

    @JsonProperty(value="maximumVolumeSize")
    public void setMaximumVolumeSize(Quantity maximumVolumeSize) {
        this.maximumVolumeSize = maximumVolumeSize;
    }

    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="nodeTopology")
    public LabelSelector getNodeTopology() {
        return this.nodeTopology;
    }

    @JsonProperty(value="nodeTopology")
    public void setNodeTopology(LabelSelector nodeTopology) {
        this.nodeTopology = nodeTopology;
    }

    @JsonProperty(value="storageClassName")
    public String getStorageClassName() {
        return this.storageClassName;
    }

    @JsonProperty(value="storageClassName")
    public void setStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    @JsonIgnore
    public CSIStorageCapacityBuilder edit() {
        return new CSIStorageCapacityBuilder(this);
    }

    @JsonIgnore
    public CSIStorageCapacityBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Generated
    public String toString() {
        return "CSIStorageCapacity(apiVersion=" + this.getApiVersion() + ", capacity=" + this.getCapacity() + ", kind=" + this.getKind() + ", maximumVolumeSize=" + this.getMaximumVolumeSize() + ", metadata=" + this.getMetadata() + ", nodeTopology=" + this.getNodeTopology() + ", storageClassName=" + this.getStorageClassName() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSIStorageCapacity)) {
            return false;
        }
        CSIStorageCapacity other = (CSIStorageCapacity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        Quantity this$capacity = this.getCapacity();
        Quantity other$capacity = other.getCapacity();
        if (this$capacity == null ? other$capacity != null : !this$capacity.equals(other$capacity)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        Quantity this$maximumVolumeSize = this.getMaximumVolumeSize();
        Quantity other$maximumVolumeSize = other.getMaximumVolumeSize();
        if (this$maximumVolumeSize == null ? other$maximumVolumeSize != null : !this$maximumVolumeSize.equals(other$maximumVolumeSize)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        LabelSelector this$nodeTopology = this.getNodeTopology();
        LabelSelector other$nodeTopology = other.getNodeTopology();
        if (this$nodeTopology == null ? other$nodeTopology != null : !this$nodeTopology.equals(other$nodeTopology)) {
            return false;
        }
        String this$storageClassName = this.getStorageClassName();
        String other$storageClassName = other.getStorageClassName();
        if (this$storageClassName == null ? other$storageClassName != null : !this$storageClassName.equals(other$storageClassName)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CSIStorageCapacity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        Quantity $capacity = this.getCapacity();
        result = result * 59 + ($capacity == null ? 43 : $capacity.hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        Quantity $maximumVolumeSize = this.getMaximumVolumeSize();
        result = result * 59 + ($maximumVolumeSize == null ? 43 : $maximumVolumeSize.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        LabelSelector $nodeTopology = this.getNodeTopology();
        result = result * 59 + ($nodeTopology == null ? 43 : $nodeTopology.hashCode());
        String $storageClassName = this.getStorageClassName();
        result = result * 59 + ($storageClassName == null ? 43 : $storageClassName.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

