package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CSINodeDriverBuilder extends CSINodeDriverFluent<CSINodeDriverBuilder> implements VisitableBuilder<CSINodeDriver,CSINodeDriverBuilder>{
  public CSINodeDriverBuilder() {
    this(new CSINodeDriver());
  }
  
  public CSINodeDriverBuilder(CSINodeDriverFluent<?> fluent) {
    this(fluent, new CSINodeDriver());
  }
  
  public CSINodeDriverBuilder(CSINodeDriverFluent<?> fluent,CSINodeDriver instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CSINodeDriverBuilder(CSINodeDriver instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CSINodeDriverFluent<?> fluent;
  
  public CSINodeDriver build() {
    CSINodeDriver buildable = new CSINodeDriver(fluent.buildAllocatable(),fluent.getName(),fluent.getNodeID(),fluent.getTopologyKeys());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}