package io.fabric8.kubernetes.api.model.resource.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceSliceListBuilder extends ResourceSliceListFluent<ResourceSliceListBuilder> implements VisitableBuilder<ResourceSliceList,ResourceSliceListBuilder>{
  public ResourceSliceListBuilder() {
    this(new ResourceSliceList());
  }
  
  public ResourceSliceListBuilder(ResourceSliceListFluent<?> fluent) {
    this(fluent, new ResourceSliceList());
  }
  
  public ResourceSliceListBuilder(ResourceSliceListFluent<?> fluent,ResourceSliceList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceSliceListBuilder(ResourceSliceList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceSliceListFluent<?> fluent;
  
  public ResourceSliceList build() {
    ResourceSliceList buildable = new ResourceSliceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}