package io.fabric8.kubernetes.api.model.resource.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BasicDeviceBuilder extends BasicDeviceFluent<BasicDeviceBuilder> implements VisitableBuilder<BasicDevice,BasicDeviceBuilder>{
  public BasicDeviceBuilder() {
    this(new BasicDevice());
  }
  
  public BasicDeviceBuilder(BasicDeviceFluent<?> fluent) {
    this(fluent, new BasicDevice());
  }
  
  public BasicDeviceBuilder(BasicDeviceFluent<?> fluent,BasicDevice instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BasicDeviceBuilder(BasicDevice instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BasicDeviceFluent<?> fluent;
  
  public BasicDevice build() {
    BasicDevice buildable = new BasicDevice(fluent.getAllNodes(),fluent.getAttributes(),fluent.getCapacity(),fluent.buildConsumesCounters(),fluent.getNodeName(),fluent.getNodeSelector(),fluent.buildTaints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}