package io.fabric8.kubernetes.api.model.resource.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CounterSetBuilder extends CounterSetFluent<CounterSetBuilder> implements VisitableBuilder<CounterSet,CounterSetBuilder>{
  public CounterSetBuilder() {
    this(new CounterSet());
  }
  
  public CounterSetBuilder(CounterSetFluent<?> fluent) {
    this(fluent, new CounterSet());
  }
  
  public CounterSetBuilder(CounterSetFluent<?> fluent,CounterSet instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CounterSetBuilder(CounterSet instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CounterSetFluent<?> fluent;
  
  public CounterSet build() {
    CounterSet buildable = new CounterSet(fluent.getCounters(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}