package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ResourceClaimStatusFluent<A extends ResourceClaimStatusFluent<A>> extends BaseFluent<A>{
  public ResourceClaimStatusFluent() {
  }
  
  public ResourceClaimStatusFluent(ResourceClaimStatus instance) {
    this.copyInstance(instance);
  }
  private AllocationResultBuilder allocation;
  private Boolean deallocationRequested;
  private String driverName;
  private ArrayList<ResourceClaimConsumerReferenceBuilder> reservedFor = new ArrayList<ResourceClaimConsumerReferenceBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ResourceClaimStatus instance) {
    instance = (instance != null ? instance : new ResourceClaimStatus());
    if (instance != null) {
          this.withAllocation(instance.getAllocation());
          this.withDeallocationRequested(instance.getDeallocationRequested());
          this.withDriverName(instance.getDriverName());
          this.withReservedFor(instance.getReservedFor());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public AllocationResult buildAllocation() {
    return this.allocation != null ? this.allocation.build() : null;
  }
  
  public A withAllocation(AllocationResult allocation) {
    this._visitables.remove("allocation");
    if (allocation != null) {
        this.allocation = new AllocationResultBuilder(allocation);
        this._visitables.get("allocation").add(this.allocation);
    } else {
        this.allocation = null;
        this._visitables.get("allocation").remove(this.allocation);
    }
    return (A) this;
  }
  
  public boolean hasAllocation() {
    return this.allocation != null;
  }
  
  public AllocationNested<A> withNewAllocation() {
    return new AllocationNested(null);
  }
  
  public AllocationNested<A> withNewAllocationLike(AllocationResult item) {
    return new AllocationNested(item);
  }
  
  public AllocationNested<A> editAllocation() {
    return withNewAllocationLike(java.util.Optional.ofNullable(buildAllocation()).orElse(null));
  }
  
  public AllocationNested<A> editOrNewAllocation() {
    return withNewAllocationLike(java.util.Optional.ofNullable(buildAllocation()).orElse(new AllocationResultBuilder().build()));
  }
  
  public AllocationNested<A> editOrNewAllocationLike(AllocationResult item) {
    return withNewAllocationLike(java.util.Optional.ofNullable(buildAllocation()).orElse(item));
  }
  
  public Boolean getDeallocationRequested() {
    return this.deallocationRequested;
  }
  
  public A withDeallocationRequested(Boolean deallocationRequested) {
    this.deallocationRequested = deallocationRequested;
    return (A) this;
  }
  
  public boolean hasDeallocationRequested() {
    return this.deallocationRequested != null;
  }
  
  public String getDriverName() {
    return this.driverName;
  }
  
  public A withDriverName(String driverName) {
    this.driverName = driverName;
    return (A) this;
  }
  
  public boolean hasDriverName() {
    return this.driverName != null;
  }
  
  public A addToReservedFor(int index,ResourceClaimConsumerReference item) {
    if (this.reservedFor == null) {this.reservedFor = new ArrayList<ResourceClaimConsumerReferenceBuilder>();}
    ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
    if (index < 0 || index >= reservedFor.size()) {
        _visitables.get("reservedFor").add(builder);
        reservedFor.add(builder);
    } else {
        _visitables.get("reservedFor").add(builder);
        reservedFor.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToReservedFor(int index,ResourceClaimConsumerReference item) {
    if (this.reservedFor == null) {this.reservedFor = new ArrayList<ResourceClaimConsumerReferenceBuilder>();}
    ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
    if (index < 0 || index >= reservedFor.size()) {
        _visitables.get("reservedFor").add(builder);
        reservedFor.add(builder);
    } else {
        _visitables.get("reservedFor").add(builder);
        reservedFor.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToReservedFor(io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimConsumerReference... items) {
    if (this.reservedFor == null) {this.reservedFor = new ArrayList<ResourceClaimConsumerReferenceBuilder>();}
    for (ResourceClaimConsumerReference item : items) {ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);_visitables.get("reservedFor").add(builder);this.reservedFor.add(builder);} return (A)this;
  }
  
  public A addAllToReservedFor(Collection<ResourceClaimConsumerReference> items) {
    if (this.reservedFor == null) {this.reservedFor = new ArrayList<ResourceClaimConsumerReferenceBuilder>();}
    for (ResourceClaimConsumerReference item : items) {ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);_visitables.get("reservedFor").add(builder);this.reservedFor.add(builder);} return (A)this;
  }
  
  public A removeFromReservedFor(io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimConsumerReference... items) {
    if (this.reservedFor == null) return (A)this;
    for (ResourceClaimConsumerReference item : items) {ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);_visitables.get("reservedFor").remove(builder); this.reservedFor.remove(builder);} return (A)this;
  }
  
  public A removeAllFromReservedFor(Collection<ResourceClaimConsumerReference> items) {
    if (this.reservedFor == null) return (A)this;
    for (ResourceClaimConsumerReference item : items) {ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);_visitables.get("reservedFor").remove(builder); this.reservedFor.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
    if (reservedFor == null) return (A) this;
    final Iterator<ResourceClaimConsumerReferenceBuilder> each = reservedFor.iterator();
    final List visitables = _visitables.get("reservedFor");
    while (each.hasNext()) {
      ResourceClaimConsumerReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ResourceClaimConsumerReference> buildReservedFor() {
    return this.reservedFor != null ? build(reservedFor) : null;
  }
  
  public ResourceClaimConsumerReference buildReservedFor(int index) {
    return this.reservedFor.get(index).build();
  }
  
  public ResourceClaimConsumerReference buildFirstReservedFor() {
    return this.reservedFor.get(0).build();
  }
  
  public ResourceClaimConsumerReference buildLastReservedFor() {
    return this.reservedFor.get(reservedFor.size() - 1).build();
  }
  
  public ResourceClaimConsumerReference buildMatchingReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
      for (ResourceClaimConsumerReferenceBuilder item : reservedFor) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
      for (ResourceClaimConsumerReferenceBuilder item : reservedFor) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withReservedFor(List<ResourceClaimConsumerReference> reservedFor) {
    if (this.reservedFor != null) {
      this._visitables.get("reservedFor").clear();
    }
    if (reservedFor != null) {
        this.reservedFor = new ArrayList();
        for (ResourceClaimConsumerReference item : reservedFor) {
          this.addToReservedFor(item);
        }
    } else {
      this.reservedFor = null;
    }
    return (A) this;
  }
  
  public A withReservedFor(io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimConsumerReference... reservedFor) {
    if (this.reservedFor != null) {
        this.reservedFor.clear();
        _visitables.remove("reservedFor");
    }
    if (reservedFor != null) {
      for (ResourceClaimConsumerReference item : reservedFor) {
        this.addToReservedFor(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasReservedFor() {
    return this.reservedFor != null && !this.reservedFor.isEmpty();
  }
  
  public A addNewReservedFor(String apiGroup,String name,String resource,String uid) {
    return (A)addToReservedFor(new ResourceClaimConsumerReference(apiGroup, name, resource, uid));
  }
  
  public ReservedForNested<A> addNewReservedFor() {
    return new ReservedForNested(-1, null);
  }
  
  public ReservedForNested<A> addNewReservedForLike(ResourceClaimConsumerReference item) {
    return new ReservedForNested(-1, item);
  }
  
  public ReservedForNested<A> setNewReservedForLike(int index,ResourceClaimConsumerReference item) {
    return new ReservedForNested(index, item);
  }
  
  public ReservedForNested<A> editReservedFor(int index) {
    if (reservedFor.size() <= index) throw new RuntimeException("Can't edit reservedFor. Index exceeds size.");
    return setNewReservedForLike(index, buildReservedFor(index));
  }
  
  public ReservedForNested<A> editFirstReservedFor() {
    if (reservedFor.size() == 0) throw new RuntimeException("Can't edit first reservedFor. The list is empty.");
    return setNewReservedForLike(0, buildReservedFor(0));
  }
  
  public ReservedForNested<A> editLastReservedFor() {
    int index = reservedFor.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last reservedFor. The list is empty.");
    return setNewReservedForLike(index, buildReservedFor(index));
  }
  
  public ReservedForNested<A> editMatchingReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<reservedFor.size();i++) { 
    if (predicate.test(reservedFor.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching reservedFor. No match found.");
    return setNewReservedForLike(index, buildReservedFor(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceClaimStatusFluent that = (ResourceClaimStatusFluent) o;
    if (!java.util.Objects.equals(allocation, that.allocation)) return false;
    if (!java.util.Objects.equals(deallocationRequested, that.deallocationRequested)) return false;
    if (!java.util.Objects.equals(driverName, that.driverName)) return false;
    if (!java.util.Objects.equals(reservedFor, that.reservedFor)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allocation,  deallocationRequested,  driverName,  reservedFor,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allocation != null) { sb.append("allocation:"); sb.append(allocation + ","); }
    if (deallocationRequested != null) { sb.append("deallocationRequested:"); sb.append(deallocationRequested + ","); }
    if (driverName != null) { sb.append("driverName:"); sb.append(driverName + ","); }
    if (reservedFor != null && !reservedFor.isEmpty()) { sb.append("reservedFor:"); sb.append(reservedFor + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDeallocationRequested() {
    return withDeallocationRequested(true);
  }
  public class AllocationNested<N> extends AllocationResultFluent<AllocationNested<N>> implements Nested<N>{
    AllocationNested(AllocationResult item) {
      this.builder = new AllocationResultBuilder(this, item);
    }
    AllocationResultBuilder builder;
    
    public N and() {
      return (N) ResourceClaimStatusFluent.this.withAllocation(builder.build());
    }
    
    public N endAllocation() {
      return and();
    }
    
  
  }
  public class ReservedForNested<N> extends ResourceClaimConsumerReferenceFluent<ReservedForNested<N>> implements Nested<N>{
    ReservedForNested(int index,ResourceClaimConsumerReference item) {
      this.index = index;
      this.builder = new ResourceClaimConsumerReferenceBuilder(this, item);
    }
    ResourceClaimConsumerReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) ResourceClaimStatusFluent.this.setToReservedFor(index,builder.build());
    }
    
    public N endReservedFor() {
      return and();
    }
    
  
  }

}