/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackend;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRule;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpec;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLS;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLSBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLSFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class IngressSpecFluent<A extends IngressSpecFluent<A>>
extends BaseFluent<A> {
    private IngressBackendBuilder defaultBackend;
    private String ingressClassName;
    private ArrayList<IngressRuleBuilder> rules = new ArrayList();
    private ArrayList<IngressTLSBuilder> tls = new ArrayList();
    private Map<String, Object> additionalProperties;

    public IngressSpecFluent() {
    }

    public IngressSpecFluent(IngressSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IngressSpec instance) {
        IngressSpec ingressSpec = instance = instance != null ? instance : new IngressSpec();
        if (instance != null) {
            this.withDefaultBackend(instance.getDefaultBackend());
            this.withIngressClassName(instance.getIngressClassName());
            this.withRules(instance.getRules());
            this.withTls(instance.getTls());
            this.withDefaultBackend(instance.getDefaultBackend());
            this.withIngressClassName(instance.getIngressClassName());
            this.withRules(instance.getRules());
            this.withTls(instance.getTls());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public IngressBackend buildDefaultBackend() {
        return this.defaultBackend != null ? this.defaultBackend.build() : null;
    }

    public A withDefaultBackend(IngressBackend defaultBackend) {
        this._visitables.get((Object)"defaultBackend").remove((Object)this.defaultBackend);
        if (defaultBackend != null) {
            this.defaultBackend = new IngressBackendBuilder(defaultBackend);
            this._visitables.get((Object)"defaultBackend").add(this.defaultBackend);
        } else {
            this.defaultBackend = null;
            this._visitables.get((Object)"defaultBackend").remove((Object)this.defaultBackend);
        }
        return (A)((Object)this);
    }

    public boolean hasDefaultBackend() {
        return this.defaultBackend != null;
    }

    public DefaultBackendNested<A> withNewDefaultBackend() {
        return new DefaultBackendNested(null);
    }

    public DefaultBackendNested<A> withNewDefaultBackendLike(IngressBackend item) {
        return new DefaultBackendNested(item);
    }

    public DefaultBackendNested<A> editDefaultBackend() {
        return this.withNewDefaultBackendLike(Optional.ofNullable(this.buildDefaultBackend()).orElse(null));
    }

    public DefaultBackendNested<A> editOrNewDefaultBackend() {
        return this.withNewDefaultBackendLike(Optional.ofNullable(this.buildDefaultBackend()).orElse(new IngressBackendBuilder().build()));
    }

    public DefaultBackendNested<A> editOrNewDefaultBackendLike(IngressBackend item) {
        return this.withNewDefaultBackendLike(Optional.ofNullable(this.buildDefaultBackend()).orElse(item));
    }

    public String getIngressClassName() {
        return this.ingressClassName;
    }

    public A withIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
        return (A)((Object)this);
    }

    public boolean hasIngressClassName() {
        return this.ingressClassName != null;
    }

    public A addToRules(int index, IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        IngressRuleBuilder builder = new IngressRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get((Object)"rules").add(index, builder);
            this.rules.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRules(int index, IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        IngressRuleBuilder builder = new IngressRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get((Object)"rules").set(index, builder);
            this.rules.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRules(IngressRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRules(Collection<IngressRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRules(IngressRule ... items) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").remove((Object)builder);
            this.rules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRules(Collection<IngressRule> items) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").remove((Object)builder);
            this.rules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRules(Predicate<IngressRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        Iterator<IngressRuleBuilder> each = this.rules.iterator();
        List visitables = this._visitables.get((Object)"rules");
        while (each.hasNext()) {
            IngressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<IngressRule> buildRules() {
        return this.rules != null ? IngressSpecFluent.build(this.rules) : null;
    }

    public IngressRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public IngressRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public IngressRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    public IngressRule buildMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        for (IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        for (IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRules(List<IngressRule> rules) {
        if (this.rules != null) {
            this._visitables.get((Object)"rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)((Object)this);
    }

    public A withRules(IngressRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove((Object)"rules");
        }
        if (rules != null) {
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public RulesNested<A> addNewRule() {
        return new RulesNested(-1, null);
    }

    public RulesNested<A> addNewRuleLike(IngressRule item) {
        return new RulesNested(-1, item);
    }

    public RulesNested<A> setNewRuleLike(int index, IngressRule item) {
        return new RulesNested(index, item);
    }

    public RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    public RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public A addToTls(int index, IngressTLS item) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        IngressTLSBuilder builder = new IngressTLSBuilder(item);
        if (index < 0 || index >= this.tls.size()) {
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        } else {
            this._visitables.get((Object)"tls").add(index, builder);
            this.tls.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTls(int index, IngressTLS item) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        IngressTLSBuilder builder = new IngressTLSBuilder(item);
        if (index < 0 || index >= this.tls.size()) {
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        } else {
            this._visitables.get((Object)"tls").set(index, builder);
            this.tls.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTls(IngressTLS ... items) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTls(Collection<IngressTLS> items) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTls(IngressTLS ... items) {
        if (this.tls == null) {
            return (A)((Object)this);
        }
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get((Object)"tls").remove((Object)builder);
            this.tls.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTls(Collection<IngressTLS> items) {
        if (this.tls == null) {
            return (A)((Object)this);
        }
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get((Object)"tls").remove((Object)builder);
            this.tls.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTls(Predicate<IngressTLSBuilder> predicate) {
        if (this.tls == null) {
            return (A)((Object)this);
        }
        Iterator<IngressTLSBuilder> each = this.tls.iterator();
        List visitables = this._visitables.get((Object)"tls");
        while (each.hasNext()) {
            IngressTLSBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<IngressTLS> buildTls() {
        return this.tls != null ? IngressSpecFluent.build(this.tls) : null;
    }

    public IngressTLS buildTl(int index) {
        return this.tls.get(index).build();
    }

    public IngressTLS buildFirstTl() {
        return this.tls.get(0).build();
    }

    public IngressTLS buildLastTl() {
        return this.tls.get(this.tls.size() - 1).build();
    }

    public IngressTLS buildMatchingTl(Predicate<IngressTLSBuilder> predicate) {
        for (IngressTLSBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTl(Predicate<IngressTLSBuilder> predicate) {
        for (IngressTLSBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTls(List<IngressTLS> tls) {
        if (this.tls != null) {
            this._visitables.get((Object)"tls").clear();
        }
        if (tls != null) {
            this.tls = new ArrayList();
            for (IngressTLS item : tls) {
                this.addToTls(item);
            }
        } else {
            this.tls = null;
        }
        return (A)((Object)this);
    }

    public A withTls(IngressTLS ... tls) {
        if (this.tls != null) {
            this.tls.clear();
            this._visitables.remove((Object)"tls");
        }
        if (tls != null) {
            for (IngressTLS item : tls) {
                this.addToTls(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTls() {
        return this.tls != null && !this.tls.isEmpty();
    }

    public TlsNested<A> addNewTl() {
        return new TlsNested(-1, null);
    }

    public TlsNested<A> addNewTlLike(IngressTLS item) {
        return new TlsNested(-1, item);
    }

    public TlsNested<A> setNewTlLike(int index, IngressTLS item) {
        return new TlsNested(index, item);
    }

    public TlsNested<A> editTl(int index) {
        if (this.tls.size() <= index) {
            throw new RuntimeException("Can't edit tls. Index exceeds size.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public TlsNested<A> editFirstTl() {
        if (this.tls.size() == 0) {
            throw new RuntimeException("Can't edit first tls. The list is empty.");
        }
        return this.setNewTlLike(0, this.buildTl(0));
    }

    public TlsNested<A> editLastTl() {
        int index = this.tls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tls. The list is empty.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public TlsNested<A> editMatchingTl(Predicate<IngressTLSBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tls.size(); ++i) {
            if (!predicate.test(this.tls.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tls. No match found.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressSpecFluent that = (IngressSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.defaultBackend, (Object)that.defaultBackend)) {
            return false;
        }
        if (!Objects.equals(this.ingressClassName, that.ingressClassName)) {
            return false;
        }
        if (!Objects.equals(this.rules, that.rules)) {
            return false;
        }
        if (!Objects.equals(this.tls, that.tls)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultBackend, this.ingressClassName, this.rules, this.tls, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultBackend != null) {
            sb.append("defaultBackend:");
            sb.append((Object)((Object)this.defaultBackend) + ",");
        }
        if (this.ingressClassName != null) {
            sb.append("ingressClassName:");
            sb.append(this.ingressClassName + ",");
        }
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(this.rules + ",");
        }
        if (this.tls != null && !this.tls.isEmpty()) {
            sb.append("tls:");
            sb.append(this.tls + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TlsNested<N>
    extends IngressTLSFluent<TlsNested<N>>
    implements Nested<N> {
        IngressTLSBuilder builder;
        int index;

        TlsNested(int index, IngressTLS item) {
            this.index = index;
            this.builder = new IngressTLSBuilder(this, item);
        }

        public N and() {
            return (N)IngressSpecFluent.this.setToTls(this.index, this.builder.build());
        }

        public N endTl() {
            return this.and();
        }
    }

    public class RulesNested<N>
    extends IngressRuleFluent<RulesNested<N>>
    implements Nested<N> {
        IngressRuleBuilder builder;
        int index;

        RulesNested(int index, IngressRule item) {
            this.index = index;
            this.builder = new IngressRuleBuilder(this, item);
        }

        public N and() {
            return (N)IngressSpecFluent.this.setToRules(this.index, this.builder.build());
        }

        public N endRule() {
            return this.and();
        }
    }

    public class DefaultBackendNested<N>
    extends IngressBackendFluent<DefaultBackendNested<N>>
    implements Nested<N> {
        IngressBackendBuilder builder;

        DefaultBackendNested(IngressBackend item) {
            this.builder = new IngressBackendBuilder(this, item);
        }

        public N and() {
            return (N)IngressSpecFluent.this.withDefaultBackend(this.builder.build());
        }

        public N endDefaultBackend() {
            return this.and();
        }
    }
}

