package io.fabric8.kubernetes.api.model.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ParentReferenceBuilder extends ParentReferenceFluent<ParentReferenceBuilder> implements VisitableBuilder<ParentReference,ParentReferenceBuilder>{
  public ParentReferenceBuilder() {
    this(new ParentReference());
  }
  
  public ParentReferenceBuilder(ParentReferenceFluent<?> fluent) {
    this(fluent, new ParentReference());
  }
  
  public ParentReferenceBuilder(ParentReferenceFluent<?> fluent,ParentReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ParentReferenceBuilder(ParentReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ParentReferenceFluent<?> fluent;
  
  public ParentReference build() {
    ParentReference buildable = new ParentReference(fluent.getGroup(),fluent.getName(),fluent.getNamespace(),fluent.getResource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}