/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.ConfigMapArgs;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.GeneratorOptions;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.GeneratorOptionsBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.GeneratorOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ConfigMapArgsFluent<A extends ConfigMapArgsFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String behavior;
    private String env;
    private List<String> envs = new ArrayList<String>();
    private List<String> files = new ArrayList<String>();
    private List<String> literals = new ArrayList<String>();
    private String name;
    private String namespace;
    private GeneratorOptionsBuilder options;

    public ConfigMapArgsFluent() {
    }

    public ConfigMapArgsFluent(ConfigMapArgs instance) {
        this.copyInstance(instance);
    }

    public A addAllToEnvs(Collection<String> items) {
        if (this.envs == null) {
            this.envs = new ArrayList<String>();
        }
        for (String item : items) {
            this.envs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToFiles(Collection<String> items) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        for (String item : items) {
            this.files.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToLiterals(Collection<String> items) {
        if (this.literals == null) {
            this.literals = new ArrayList<String>();
        }
        for (String item : items) {
            this.literals.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToEnvs(String ... items) {
        if (this.envs == null) {
            this.envs = new ArrayList<String>();
        }
        for (String item : items) {
            this.envs.add(item);
        }
        return (A)((Object)this);
    }

    public A addToEnvs(int index, String item) {
        if (this.envs == null) {
            this.envs = new ArrayList<String>();
        }
        this.envs.add(index, item);
        return (A)((Object)this);
    }

    public A addToFiles(String ... items) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        for (String item : items) {
            this.files.add(item);
        }
        return (A)((Object)this);
    }

    public A addToFiles(int index, String item) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        this.files.add(index, item);
        return (A)((Object)this);
    }

    public A addToLiterals(String ... items) {
        if (this.literals == null) {
            this.literals = new ArrayList<String>();
        }
        for (String item : items) {
            this.literals.add(item);
        }
        return (A)((Object)this);
    }

    public A addToLiterals(int index, String item) {
        if (this.literals == null) {
            this.literals = new ArrayList<String>();
        }
        this.literals.add(index, item);
        return (A)((Object)this);
    }

    public GeneratorOptions buildOptions() {
        return this.options != null ? this.options.build() : null;
    }

    protected void copyInstance(ConfigMapArgs instance) {
        ConfigMapArgs configMapArgs = instance = instance != null ? instance : new ConfigMapArgs();
        if (instance != null) {
            this.withBehavior(instance.getBehavior());
            this.withEnv(instance.getEnv());
            this.withEnvs(instance.getEnvs());
            this.withFiles(instance.getFiles());
            this.withLiterals(instance.getLiterals());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withOptions(instance.getOptions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public OptionsNested<A> editOptions() {
        return this.withNewOptionsLike(Optional.ofNullable(this.buildOptions()).orElse(null));
    }

    public OptionsNested<A> editOrNewOptions() {
        return this.withNewOptionsLike(Optional.ofNullable(this.buildOptions()).orElse(new GeneratorOptionsBuilder().build()));
    }

    public OptionsNested<A> editOrNewOptionsLike(GeneratorOptions item) {
        return this.withNewOptionsLike(Optional.ofNullable(this.buildOptions()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapArgsFluent that = (ConfigMapArgsFluent)((Object)o);
        if (!Objects.equals(this.behavior, that.behavior)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.envs, that.envs)) {
            return false;
        }
        if (!Objects.equals(this.files, that.files)) {
            return false;
        }
        if (!Objects.equals(this.literals, that.literals)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals((Object)this.options, (Object)that.options)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getBehavior() {
        return this.behavior;
    }

    public String getEnv() {
        return this.env;
    }

    public String getEnv(int index) {
        return this.envs.get(index);
    }

    public List<String> getEnvs() {
        return this.envs;
    }

    public String getFile(int index) {
        return this.files.get(index);
    }

    public List<String> getFiles() {
        return this.files;
    }

    public String getFirstEnv() {
        return this.envs.get(0);
    }

    public String getFirstFile() {
        return this.files.get(0);
    }

    public String getFirstLiteral() {
        return this.literals.get(0);
    }

    public String getLastEnv() {
        return this.envs.get(this.envs.size() - 1);
    }

    public String getLastFile() {
        return this.files.get(this.files.size() - 1);
    }

    public String getLastLiteral() {
        return this.literals.get(this.literals.size() - 1);
    }

    public String getLiteral(int index) {
        return this.literals.get(index);
    }

    public List<String> getLiterals() {
        return this.literals;
    }

    public String getMatchingEnv(Predicate<String> predicate) {
        for (String item : this.envs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingFile(Predicate<String> predicate) {
        for (String item : this.files) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingLiteral(Predicate<String> predicate) {
        for (String item : this.literals) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBehavior() {
        return this.behavior != null;
    }

    public boolean hasEnv() {
        return this.env != null;
    }

    public boolean hasEnvs() {
        return this.envs != null && !this.envs.isEmpty();
    }

    public boolean hasFiles() {
        return this.files != null && !this.files.isEmpty();
    }

    public boolean hasLiterals() {
        return this.literals != null && !this.literals.isEmpty();
    }

    public boolean hasMatchingEnv(Predicate<String> predicate) {
        for (String item : this.envs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingFile(Predicate<String> predicate) {
        for (String item : this.files) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingLiteral(Predicate<String> predicate) {
        for (String item : this.literals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.behavior, this.env, this.envs, this.files, this.literals, this.name, this.namespace, this.options, this.additionalProperties});
    }

    public A removeAllFromEnvs(Collection<String> items) {
        if (this.envs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.envs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFiles(Collection<String> items) {
        if (this.files == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.files.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLiterals(Collection<String> items) {
        if (this.literals == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.literals.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromEnvs(String ... items) {
        if (this.envs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.envs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromFiles(String ... items) {
        if (this.files == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.files.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromLiterals(String ... items) {
        if (this.literals == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.literals.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToEnvs(int index, String item) {
        if (this.envs == null) {
            this.envs = new ArrayList<String>();
        }
        this.envs.set(index, item);
        return (A)((Object)this);
    }

    public A setToFiles(int index, String item) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        this.files.set(index, item);
        return (A)((Object)this);
    }

    public A setToLiterals(int index, String item) {
        if (this.literals == null) {
            this.literals = new ArrayList<String>();
        }
        this.literals.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.behavior != null) {
            sb.append("behavior:");
            sb.append(this.behavior);
            sb.append(",");
        }
        if (this.env != null) {
            sb.append("env:");
            sb.append(this.env);
            sb.append(",");
        }
        if (this.envs != null && !this.envs.isEmpty()) {
            sb.append("envs:");
            sb.append(this.envs);
            sb.append(",");
        }
        if (this.files != null && !this.files.isEmpty()) {
            sb.append("files:");
            sb.append(this.files);
            sb.append(",");
        }
        if (this.literals != null && !this.literals.isEmpty()) {
            sb.append("literals:");
            sb.append(this.literals);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace);
            sb.append(",");
        }
        if (this.options != null) {
            sb.append("options:");
            sb.append((Object)this.options);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withBehavior(String behavior) {
        this.behavior = behavior;
        return (A)((Object)this);
    }

    public A withEnv(String env) {
        this.env = env;
        return (A)((Object)this);
    }

    public A withEnvs(List<String> envs) {
        if (envs != null) {
            this.envs = new ArrayList<String>();
            for (String item : envs) {
                this.addToEnvs(item);
            }
        } else {
            this.envs = null;
        }
        return (A)((Object)this);
    }

    public A withEnvs(String ... envs) {
        if (this.envs != null) {
            this.envs.clear();
            this._visitables.remove((Object)"envs");
        }
        if (envs != null) {
            for (String item : envs) {
                this.addToEnvs(item);
            }
        }
        return (A)((Object)this);
    }

    public A withFiles(List<String> files) {
        if (files != null) {
            this.files = new ArrayList<String>();
            for (String item : files) {
                this.addToFiles(item);
            }
        } else {
            this.files = null;
        }
        return (A)((Object)this);
    }

    public A withFiles(String ... files) {
        if (this.files != null) {
            this.files.clear();
            this._visitables.remove((Object)"files");
        }
        if (files != null) {
            for (String item : files) {
                this.addToFiles(item);
            }
        }
        return (A)((Object)this);
    }

    public A withLiterals(List<String> literals) {
        if (literals != null) {
            this.literals = new ArrayList<String>();
            for (String item : literals) {
                this.addToLiterals(item);
            }
        } else {
            this.literals = null;
        }
        return (A)((Object)this);
    }

    public A withLiterals(String ... literals) {
        if (this.literals != null) {
            this.literals.clear();
            this._visitables.remove((Object)"literals");
        }
        if (literals != null) {
            for (String item : literals) {
                this.addToLiterals(item);
            }
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public OptionsNested<A> withNewOptions() {
        return new OptionsNested(null);
    }

    public OptionsNested<A> withNewOptionsLike(GeneratorOptions item) {
        return new OptionsNested(item);
    }

    public A withOptions(GeneratorOptions options) {
        this._visitables.remove((Object)"options");
        if (options != null) {
            this.options = new GeneratorOptionsBuilder(options);
            this._visitables.get((Object)"options").add(this.options);
        } else {
            this.options = null;
            this._visitables.get((Object)"options").remove((Object)this.options);
        }
        return (A)((Object)this);
    }

    public class OptionsNested<N>
    extends GeneratorOptionsFluent<OptionsNested<N>>
    implements Nested<N> {
        GeneratorOptionsBuilder builder;

        OptionsNested(GeneratorOptions item) {
            this.builder = new GeneratorOptionsBuilder(this, item);
        }

        public N and() {
            return (N)ConfigMapArgsFluent.this.withOptions(this.builder.build());
        }

        public N endOptions() {
            return this.and();
        }
    }
}

