package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SortOptionsBuilder extends SortOptionsFluent<SortOptionsBuilder> implements VisitableBuilder<SortOptions,SortOptionsBuilder>{
  public SortOptionsBuilder() {
    this(new SortOptions());
  }
  
  public SortOptionsBuilder(SortOptionsFluent<?> fluent) {
    this(fluent, new SortOptions());
  }
  
  public SortOptionsBuilder(SortOptionsFluent<?> fluent,SortOptions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SortOptionsBuilder(SortOptions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SortOptionsFluent<?> fluent;
  
  public SortOptions build() {
    SortOptions buildable = new SortOptions(fluent.buildLegacySortOptions(),fluent.getOrder());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}