package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ReplicaBuilder extends ReplicaFluent<ReplicaBuilder> implements VisitableBuilder<Replica,ReplicaBuilder>{
  public ReplicaBuilder() {
    this(new Replica());
  }
  
  public ReplicaBuilder(ReplicaFluent<?> fluent) {
    this(fluent, new Replica());
  }
  
  public ReplicaBuilder(ReplicaFluent<?> fluent,Replica instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ReplicaBuilder(Replica instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ReplicaFluent<?> fluent;
  
  public Replica build() {
    Replica buildable = new Replica(fluent.getCount(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}