package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HelmChartArgsBuilder extends HelmChartArgsFluent<HelmChartArgsBuilder> implements VisitableBuilder<HelmChartArgs,HelmChartArgsBuilder>{
  public HelmChartArgsBuilder() {
    this(new HelmChartArgs());
  }
  
  public HelmChartArgsBuilder(HelmChartArgsFluent<?> fluent) {
    this(fluent, new HelmChartArgs());
  }
  
  public HelmChartArgsBuilder(HelmChartArgsFluent<?> fluent,HelmChartArgs instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HelmChartArgsBuilder(HelmChartArgs instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HelmChartArgsFluent<?> fluent;
  
  public HelmChartArgs build() {
    HelmChartArgs buildable = new HelmChartArgs(fluent.getChartHome(),fluent.getChartName(),fluent.getChartRepoName(),fluent.getChartRepoUrl(),fluent.getChartVersion(),fluent.getExtraArgs(),fluent.getHelmBin(),fluent.getHelmHome(),fluent.getReleaseName(),fluent.getReleaseNamespace(),fluent.getValues(),fluent.getValuesLocal(),fluent.getValuesMerge());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}